<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kundenportalGetDocumentResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Kundenportal GetDocument Service Response
 * @subpackage Structs
 */
class KundenportalGetDocumentResponse extends AbstractStructBase
{
    /**
     * The files
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Attachment[]
     */
    public $files;
    /**
     * The evpServiceFault
     * Meta information extracted from the WSDL
     * - documentation: Optional Fehler
     * - minOccurs: 0
     * @var \StructType\EvpServiceFault
     */
    public $evpServiceFault;
    /**
     * Constructor method for kundenportalGetDocumentResponse
     * @uses KundenportalGetDocumentResponse::setFiles()
     * @uses KundenportalGetDocumentResponse::setEvpServiceFault()
     * @param \StructType\Attachment[] $files
     * @param \StructType\EvpServiceFault $evpServiceFault
     */
    public function __construct(array $files = array(), \StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this
            ->setFiles($files)
            ->setEvpServiceFault($evpServiceFault);
    }
    /**
     * Get files value
     * @return \StructType\Attachment[]|null
     */
    public function getFiles()
    {
        return $this->files;
    }
    /**
     * This method is responsible for validating the values passed to the setFiles method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFiles method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFilesForArrayConstraintsFromSetFiles(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kundenportalGetDocumentResponseFilesItem) {
            // validation for constraint: itemType
            if (!$kundenportalGetDocumentResponseFilesItem instanceof \StructType\Attachment) {
                $invalidValues[] = is_object($kundenportalGetDocumentResponseFilesItem) ? get_class($kundenportalGetDocumentResponseFilesItem) : sprintf('%s(%s)', gettype($kundenportalGetDocumentResponseFilesItem), var_export($kundenportalGetDocumentResponseFilesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The files property can only contain items of type \StructType\Attachment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set files value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment[] $files
     * @return \StructType\KundenportalGetDocumentResponse
     */
    public function setFiles(array $files = array())
    {
        // validation for constraint: array
        if ('' !== ($filesArrayErrorMessage = self::validateFilesForArrayConstraintsFromSetFiles($files))) {
            throw new \InvalidArgumentException($filesArrayErrorMessage, __LINE__);
        }
        $this->files = $files;
        return $this;
    }
    /**
     * Add item to files value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment $item
     * @return \StructType\KundenportalGetDocumentResponse
     */
    public function addToFiles(\StructType\Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attachment) {
            throw new \InvalidArgumentException(sprintf('The files property can only contain items of type \StructType\Attachment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->files[] = $item;
        return $this;
    }
    /**
     * Get evpServiceFault value
     * @return \StructType\EvpServiceFault|null
     */
    public function getEvpServiceFault()
    {
        return $this->evpServiceFault;
    }
    /**
     * Set evpServiceFault value
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @return \StructType\KundenportalGetDocumentResponse
     */
    public function setEvpServiceFault(\StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this->evpServiceFault = $evpServiceFault;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KundenportalGetDocumentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
