<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kundenportalGetDocumentRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Kundenportal GetDocument Service Request
 * @subpackage Structs
 */
class KundenportalGetDocumentRequest extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Login
     */
    public $login;
    /**
     * The documentid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $documentid;
    /**
     * Constructor method for kundenportalGetDocumentRequest
     * @uses KundenportalGetDocumentRequest::setLogin()
     * @uses KundenportalGetDocumentRequest::setDocumentid()
     * @param \StructType\Login $login
     * @param int $documentid
     */
    public function __construct(\StructType\Login $login = null, $documentid = null)
    {
        $this
            ->setLogin($login)
            ->setDocumentid($documentid);
    }
    /**
     * Get login value
     * @return \StructType\Login
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\KundenportalGetDocumentRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get documentid value
     * @return int|null
     */
    public function getDocumentid()
    {
        return $this->documentid;
    }
    /**
     * Set documentid value
     * @param int $documentid
     * @return \StructType\KundenportalGetDocumentRequest
     */
    public function setDocumentid($documentid = null)
    {
        // validation for constraint: int
        if (!is_null($documentid) && !(is_int($documentid) || ctype_digit($documentid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentid, true), gettype($documentid)), __LINE__);
        }
        $this->documentid = $documentid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KundenportalGetDocumentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
