<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kundenportalClaimAdviceRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Kundenportal ClaimAdvice Request
 * @subpackage Structs
 */
class KundenportalClaimAdviceRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The claimAdviceBusinessCaseNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $claimAdviceBusinessCaseNumber;
    /**
     * The claimAdviceData
     * @var \StructType\KundenPortalClaimAdvice
     */
    public $claimAdviceData;
    /**
     * Constructor method for kundenportalClaimAdviceRequest
     * @uses KundenportalClaimAdviceRequest::setLogin()
     * @uses KundenportalClaimAdviceRequest::setClaimAdviceBusinessCaseNumber()
     * @uses KundenportalClaimAdviceRequest::setClaimAdviceData()
     * @param \StructType\Login $login
     * @param int $claimAdviceBusinessCaseNumber
     * @param \StructType\KundenPortalClaimAdvice $claimAdviceData
     */
    public function __construct(\StructType\Login $login = null, $claimAdviceBusinessCaseNumber = null, \StructType\KundenPortalClaimAdvice $claimAdviceData = null)
    {
        $this
            ->setLogin($login)
            ->setClaimAdviceBusinessCaseNumber($claimAdviceBusinessCaseNumber)
            ->setClaimAdviceData($claimAdviceData);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\KundenportalClaimAdviceRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get claimAdviceBusinessCaseNumber value
     * @return int|null
     */
    public function getClaimAdviceBusinessCaseNumber()
    {
        return $this->claimAdviceBusinessCaseNumber;
    }
    /**
     * Set claimAdviceBusinessCaseNumber value
     * @param int $claimAdviceBusinessCaseNumber
     * @return \StructType\KundenportalClaimAdviceRequest
     */
    public function setClaimAdviceBusinessCaseNumber($claimAdviceBusinessCaseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($claimAdviceBusinessCaseNumber) && !(is_int($claimAdviceBusinessCaseNumber) || ctype_digit($claimAdviceBusinessCaseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($claimAdviceBusinessCaseNumber, true), gettype($claimAdviceBusinessCaseNumber)), __LINE__);
        }
        $this->claimAdviceBusinessCaseNumber = $claimAdviceBusinessCaseNumber;
        return $this;
    }
    /**
     * Get claimAdviceData value
     * @return \StructType\KundenPortalClaimAdvice|null
     */
    public function getClaimAdviceData()
    {
        return $this->claimAdviceData;
    }
    /**
     * Set claimAdviceData value
     * @param \StructType\KundenPortalClaimAdvice $claimAdviceData
     * @return \StructType\KundenportalClaimAdviceRequest
     */
    public function setClaimAdviceData(\StructType\KundenPortalClaimAdvice $claimAdviceData = null)
    {
        $this->claimAdviceData = $claimAdviceData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KundenportalClaimAdviceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
