<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kundenPortalClaimAdvice StructType
 * @subpackage Structs
 */
class KundenPortalClaimAdvice extends AbstractStructBase
{
    /**
     * The polNr
     * @var string
     */
    public $polNr;
    /**
     * The typOfClaim
     * @var string
     */
    public $typOfClaim;
    /**
     * The propertyInsurance
     * Meta information extracted from the WSDL
     * - choice: propertyInsurance | carInsurance | accidentInsurance | healthInsurance
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PropertyInsurance
     */
    public $propertyInsurance;
    /**
     * The carInsurance
     * Meta information extracted from the WSDL
     * - choice: propertyInsurance | carInsurance | accidentInsurance | healthInsurance
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CarInsurance
     */
    public $carInsurance;
    /**
     * The accidentInsurance
     * Meta information extracted from the WSDL
     * - choice: propertyInsurance | carInsurance | accidentInsurance | healthInsurance
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccidentInsurance
     */
    public $accidentInsurance;
    /**
     * The healthInsurance
     * Meta information extracted from the WSDL
     * - choice: propertyInsurance | carInsurance | accidentInsurance | healthInsurance
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\HealthInsurance
     */
    public $healthInsurance;
    /**
     * The transferMoneyTo
     * @var \StructType\BankAccount
     */
    public $transferMoneyTo;
    /**
     * The attachments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Attachment
     */
    public $attachments;
    /**
     * The contactDataEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contactDataEmail;
    /**
     * The contactDataTelephone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contactDataTelephone;
    /**
     * The sendClaimTo
     * Meta information extracted from the WSDL
     * - documentation: Schadenmeldung an Generali oder Betreuer schicken
     * - base: xsd:string
     * @var string
     */
    public $sendClaimTo;
    /**
     * Constructor method for kundenPortalClaimAdvice
     * @uses KundenPortalClaimAdvice::setPolNr()
     * @uses KundenPortalClaimAdvice::setTypOfClaim()
     * @uses KundenPortalClaimAdvice::setPropertyInsurance()
     * @uses KundenPortalClaimAdvice::setCarInsurance()
     * @uses KundenPortalClaimAdvice::setAccidentInsurance()
     * @uses KundenPortalClaimAdvice::setHealthInsurance()
     * @uses KundenPortalClaimAdvice::setTransferMoneyTo()
     * @uses KundenPortalClaimAdvice::setAttachments()
     * @uses KundenPortalClaimAdvice::setContactDataEmail()
     * @uses KundenPortalClaimAdvice::setContactDataTelephone()
     * @uses KundenPortalClaimAdvice::setSendClaimTo()
     * @param string $polNr
     * @param string $typOfClaim
     * @param \StructType\PropertyInsurance $propertyInsurance
     * @param \StructType\CarInsurance $carInsurance
     * @param \StructType\AccidentInsurance $accidentInsurance
     * @param \StructType\HealthInsurance $healthInsurance
     * @param \StructType\BankAccount $transferMoneyTo
     * @param \StructType\Attachment $attachments
     * @param string $contactDataEmail
     * @param string $contactDataTelephone
     * @param string $sendClaimTo
     */
    public function __construct($polNr = null, $typOfClaim = null, \StructType\PropertyInsurance $propertyInsurance = null, \StructType\CarInsurance $carInsurance = null, \StructType\AccidentInsurance $accidentInsurance = null, \StructType\HealthInsurance $healthInsurance = null, \StructType\BankAccount $transferMoneyTo = null, \StructType\Attachment $attachments = null, $contactDataEmail = null, $contactDataTelephone = null, $sendClaimTo = null)
    {
        $this
            ->setPolNr($polNr)
            ->setTypOfClaim($typOfClaim)
            ->setPropertyInsurance($propertyInsurance)
            ->setCarInsurance($carInsurance)
            ->setAccidentInsurance($accidentInsurance)
            ->setHealthInsurance($healthInsurance)
            ->setTransferMoneyTo($transferMoneyTo)
            ->setAttachments($attachments)
            ->setContactDataEmail($contactDataEmail)
            ->setContactDataTelephone($contactDataTelephone)
            ->setSendClaimTo($sendClaimTo);
    }
    /**
     * Get polNr value
     * @return string|null
     */
    public function getPolNr()
    {
        return $this->polNr;
    }
    /**
     * Set polNr value
     * @param string $polNr
     * @return \StructType\KundenPortalClaimAdvice
     */
    public function setPolNr($polNr = null)
    {
        // validation for constraint: string
        if (!is_null($polNr) && !is_string($polNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($polNr, true), gettype($polNr)), __LINE__);
        }
        $this->polNr = $polNr;
        return $this;
    }
    /**
     * Get typOfClaim value
     * @return string|null
     */
    public function getTypOfClaim()
    {
        return $this->typOfClaim;
    }
    /**
     * Set typOfClaim value
     * @uses \EnumType\ClaimCategory::valueIsValid()
     * @uses \EnumType\ClaimCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typOfClaim
     * @return \StructType\KundenPortalClaimAdvice
     */
    public function setTypOfClaim($typOfClaim = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ClaimCategory::valueIsValid($typOfClaim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ClaimCategory', is_array($typOfClaim) ? implode(', ', $typOfClaim) : var_export($typOfClaim, true), implode(', ', \EnumType\ClaimCategory::getValidValues())), __LINE__);
        }
        $this->typOfClaim = $typOfClaim;
        return $this;
    }
    /**
     * Get propertyInsurance value
     * @return \StructType\PropertyInsurance|null
     */
    public function getPropertyInsurance()
    {
        return isset($this->propertyInsurance) ? $this->propertyInsurance : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPropertyInsurance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPropertyInsurance method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePropertyInsuranceForChoiceConstraintsFromSetPropertyInsurance($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'carInsurance',
            'accidentInsurance',
            'healthInsurance',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property propertyInsurance can\'t be set as the property %s is already set. Only one property must be set among these properties: propertyInsurance, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set propertyInsurance value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PropertyInsurance $propertyInsurance
     * @return \StructType\KundenPortalClaimAdvice
     */
    public function setPropertyInsurance(\StructType\PropertyInsurance $propertyInsurance = null)
    {
        // validation for constraint: choice(propertyInsurance, carInsurance, accidentInsurance, healthInsurance)
        if ('' !== ($propertyInsuranceChoiceErrorMessage = self::validatePropertyInsuranceForChoiceConstraintsFromSetPropertyInsurance($propertyInsurance))) {
            throw new \InvalidArgumentException($propertyInsuranceChoiceErrorMessage, __LINE__);
        }
        if (is_null($propertyInsurance) || (is_array($propertyInsurance) && empty($propertyInsurance))) {
            unset($this->propertyInsurance);
        } else {
            $this->propertyInsurance = $propertyInsurance;
        }
        return $this;
    }
    /**
     * Get carInsurance value
     * @return \StructType\CarInsurance|null
     */
    public function getCarInsurance()
    {
        return isset($this->carInsurance) ? $this->carInsurance : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCarInsurance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCarInsurance method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCarInsuranceForChoiceConstraintsFromSetCarInsurance($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'propertyInsurance',
            'accidentInsurance',
            'healthInsurance',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property carInsurance can\'t be set as the property %s is already set. Only one property must be set among these properties: carInsurance, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set carInsurance value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CarInsurance $carInsurance
     * @return \StructType\KundenPortalClaimAdvice
     */
    public function setCarInsurance(\StructType\CarInsurance $carInsurance = null)
    {
        // validation for constraint: choice(propertyInsurance, carInsurance, accidentInsurance, healthInsurance)
        if ('' !== ($carInsuranceChoiceErrorMessage = self::validateCarInsuranceForChoiceConstraintsFromSetCarInsurance($carInsurance))) {
            throw new \InvalidArgumentException($carInsuranceChoiceErrorMessage, __LINE__);
        }
        if (is_null($carInsurance) || (is_array($carInsurance) && empty($carInsurance))) {
            unset($this->carInsurance);
        } else {
            $this->carInsurance = $carInsurance;
        }
        return $this;
    }
    /**
     * Get accidentInsurance value
     * @return \StructType\AccidentInsurance|null
     */
    public function getAccidentInsurance()
    {
        return isset($this->accidentInsurance) ? $this->accidentInsurance : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAccidentInsurance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccidentInsurance method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAccidentInsuranceForChoiceConstraintsFromSetAccidentInsurance($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'propertyInsurance',
            'carInsurance',
            'healthInsurance',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property accidentInsurance can\'t be set as the property %s is already set. Only one property must be set among these properties: accidentInsurance, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set accidentInsurance value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AccidentInsurance $accidentInsurance
     * @return \StructType\KundenPortalClaimAdvice
     */
    public function setAccidentInsurance(\StructType\AccidentInsurance $accidentInsurance = null)
    {
        // validation for constraint: choice(propertyInsurance, carInsurance, accidentInsurance, healthInsurance)
        if ('' !== ($accidentInsuranceChoiceErrorMessage = self::validateAccidentInsuranceForChoiceConstraintsFromSetAccidentInsurance($accidentInsurance))) {
            throw new \InvalidArgumentException($accidentInsuranceChoiceErrorMessage, __LINE__);
        }
        if (is_null($accidentInsurance) || (is_array($accidentInsurance) && empty($accidentInsurance))) {
            unset($this->accidentInsurance);
        } else {
            $this->accidentInsurance = $accidentInsurance;
        }
        return $this;
    }
    /**
     * Get healthInsurance value
     * @return \StructType\HealthInsurance|null
     */
    public function getHealthInsurance()
    {
        return isset($this->healthInsurance) ? $this->healthInsurance : null;
    }
    /**
     * This method is responsible for validating the value passed to the setHealthInsurance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHealthInsurance method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateHealthInsuranceForChoiceConstraintsFromSetHealthInsurance($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'propertyInsurance',
            'carInsurance',
            'accidentInsurance',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property healthInsurance can\'t be set as the property %s is already set. Only one property must be set among these properties: healthInsurance, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set healthInsurance value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\HealthInsurance $healthInsurance
     * @return \StructType\KundenPortalClaimAdvice
     */
    public function setHealthInsurance(\StructType\HealthInsurance $healthInsurance = null)
    {
        // validation for constraint: choice(propertyInsurance, carInsurance, accidentInsurance, healthInsurance)
        if ('' !== ($healthInsuranceChoiceErrorMessage = self::validateHealthInsuranceForChoiceConstraintsFromSetHealthInsurance($healthInsurance))) {
            throw new \InvalidArgumentException($healthInsuranceChoiceErrorMessage, __LINE__);
        }
        if (is_null($healthInsurance) || (is_array($healthInsurance) && empty($healthInsurance))) {
            unset($this->healthInsurance);
        } else {
            $this->healthInsurance = $healthInsurance;
        }
        return $this;
    }
    /**
     * Get transferMoneyTo value
     * @return \StructType\BankAccount|null
     */
    public function getTransferMoneyTo()
    {
        return $this->transferMoneyTo;
    }
    /**
     * Set transferMoneyTo value
     * @param \StructType\BankAccount $transferMoneyTo
     * @return \StructType\KundenPortalClaimAdvice
     */
    public function setTransferMoneyTo(\StructType\BankAccount $transferMoneyTo = null)
    {
        $this->transferMoneyTo = $transferMoneyTo;
        return $this;
    }
    /**
     * Get attachments value
     * @return \StructType\Attachment|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @param \StructType\Attachment $attachments
     * @return \StructType\KundenPortalClaimAdvice
     */
    public function setAttachments(\StructType\Attachment $attachments = null)
    {
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Get contactDataEmail value
     * @return string|null
     */
    public function getContactDataEmail()
    {
        return $this->contactDataEmail;
    }
    /**
     * Set contactDataEmail value
     * @param string $contactDataEmail
     * @return \StructType\KundenPortalClaimAdvice
     */
    public function setContactDataEmail($contactDataEmail = null)
    {
        // validation for constraint: string
        if (!is_null($contactDataEmail) && !is_string($contactDataEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactDataEmail, true), gettype($contactDataEmail)), __LINE__);
        }
        $this->contactDataEmail = $contactDataEmail;
        return $this;
    }
    /**
     * Get contactDataTelephone value
     * @return string|null
     */
    public function getContactDataTelephone()
    {
        return $this->contactDataTelephone;
    }
    /**
     * Set contactDataTelephone value
     * @param string $contactDataTelephone
     * @return \StructType\KundenPortalClaimAdvice
     */
    public function setContactDataTelephone($contactDataTelephone = null)
    {
        // validation for constraint: string
        if (!is_null($contactDataTelephone) && !is_string($contactDataTelephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactDataTelephone, true), gettype($contactDataTelephone)), __LINE__);
        }
        $this->contactDataTelephone = $contactDataTelephone;
        return $this;
    }
    /**
     * Get sendClaimTo value
     * @return string|null
     */
    public function getSendClaimTo()
    {
        return $this->sendClaimTo;
    }
    /**
     * Set sendClaimTo value
     * @param string $sendClaimTo
     * @return \StructType\KundenPortalClaimAdvice
     */
    public function setSendClaimTo($sendClaimTo = null)
    {
        // validation for constraint: string
        if (!is_null($sendClaimTo) && !is_string($sendClaimTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendClaimTo, true), gettype($sendClaimTo)), __LINE__);
        }
        $this->sendClaimTo = $sendClaimTo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KundenPortalClaimAdvice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
