<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for kommunikationType StructType
 * @subpackage Structs
 */
class KommunikationType extends AbstractStructBase
{
    /**
     * The eintrag
     * Meta information extracted from the WSDL
     * - documentation: Telefonnummer, eMail-Adresse, Homepage, …
     * - base: xs:string
     * - maxLength: 50
     * @var string
     */
    public $eintrag;
    /**
     * The kommunikationsTyp
     * @var string
     */
    public $kommunikationsTyp;
    /**
     * The kommentar
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 50
     * @var string
     */
    public $kommentar;
    /**
     * The uebertragungFreigeben
     * Meta information extracted from the WSDL
     * - documentation: Gibt an, ob der Kommunikationseintrag an das Generali Backoffice geschickt wird.
     * @var string
     */
    public $uebertragungFreigeben;
    /**
     * Constructor method for kommunikationType
     * @uses KommunikationType::setEintrag()
     * @uses KommunikationType::setKommunikationsTyp()
     * @uses KommunikationType::setKommentar()
     * @uses KommunikationType::setUebertragungFreigeben()
     * @param string $eintrag
     * @param string $kommunikationsTyp
     * @param string $kommentar
     * @param string $uebertragungFreigeben
     */
    public function __construct($eintrag = null, $kommunikationsTyp = null, $kommentar = null, $uebertragungFreigeben = null)
    {
        $this
            ->setEintrag($eintrag)
            ->setKommunikationsTyp($kommunikationsTyp)
            ->setKommentar($kommentar)
            ->setUebertragungFreigeben($uebertragungFreigeben);
    }
    /**
     * Get eintrag value
     * @return string|null
     */
    public function getEintrag()
    {
        return $this->eintrag;
    }
    /**
     * Set eintrag value
     * @param string $eintrag
     * @return \StructType\KommunikationType
     */
    public function setEintrag($eintrag = null)
    {
        // validation for constraint: string
        if (!is_null($eintrag) && !is_string($eintrag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eintrag, true), gettype($eintrag)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($eintrag) && mb_strlen($eintrag) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($eintrag)), __LINE__);
        }
        $this->eintrag = $eintrag;
        return $this;
    }
    /**
     * Get kommunikationsTyp value
     * @return string|null
     */
    public function getKommunikationsTyp()
    {
        return $this->kommunikationsTyp;
    }
    /**
     * Set kommunikationsTyp value
     * @uses \EnumType\KommunikationsTypType::valueIsValid()
     * @uses \EnumType\KommunikationsTypType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kommunikationsTyp
     * @return \StructType\KommunikationType
     */
    public function setKommunikationsTyp($kommunikationsTyp = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KommunikationsTypType::valueIsValid($kommunikationsTyp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KommunikationsTypType', is_array($kommunikationsTyp) ? implode(', ', $kommunikationsTyp) : var_export($kommunikationsTyp, true), implode(', ', \EnumType\KommunikationsTypType::getValidValues())), __LINE__);
        }
        $this->kommunikationsTyp = $kommunikationsTyp;
        return $this;
    }
    /**
     * Get kommentar value
     * @return string|null
     */
    public function getKommentar()
    {
        return $this->kommentar;
    }
    /**
     * Set kommentar value
     * @param string $kommentar
     * @return \StructType\KommunikationType
     */
    public function setKommentar($kommentar = null)
    {
        // validation for constraint: string
        if (!is_null($kommentar) && !is_string($kommentar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kommentar, true), gettype($kommentar)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($kommentar) && mb_strlen($kommentar) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($kommentar)), __LINE__);
        }
        $this->kommentar = $kommentar;
        return $this;
    }
    /**
     * Get uebertragungFreigeben value
     * @return string|null
     */
    public function getUebertragungFreigeben()
    {
        return $this->uebertragungFreigeben;
    }
    /**
     * Set uebertragungFreigeben value
     * @uses \EnumType\JaNeinType::valueIsValid()
     * @uses \EnumType\JaNeinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $uebertragungFreigeben
     * @return \StructType\KommunikationType
     */
    public function setUebertragungFreigeben($uebertragungFreigeben = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinType::valueIsValid($uebertragungFreigeben)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinType', is_array($uebertragungFreigeben) ? implode(', ', $uebertragungFreigeben) : var_export($uebertragungFreigeben, true), implode(', ', \EnumType\JaNeinType::getValidValues())), __LINE__);
        }
        $this->uebertragungFreigeben = $uebertragungFreigeben;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KommunikationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
