<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KeyValuePair StructType
 * Meta information extracted from the WSDL
 * - documentation: KeyValuePair used for mappings
 * @subpackage Structs
 */
class KeyValuePair extends AbstractStructBase
{
    /**
     * The key
     * Meta information extracted from the WSDL
     * - documentation: String key of the attribute. If 'VPMS/A_test' is used the key is mapped to VPMS | Status key aus der Datenbank. Z.b. 90 ... Angebot
     * - base: xsd:string
     * - maxLength: 60
     * @var string
     */
    public $key;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - documentation: String value
     * - base: xsd:string
     * - maxLength: 500
     * @var string
     */
    public $value;
    /**
     * Constructor method for KeyValuePair
     * @uses KeyValuePair::setKey()
     * @uses KeyValuePair::setValue()
     * @param string $key
     * @param string $value
     */
    public function __construct($key = null, $value = null)
    {
        $this
            ->setKey($key)
            ->setValue($value);
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\KeyValuePair
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($key) && mb_strlen($key) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\KeyValuePair
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($value) && mb_strlen($value) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\KeyValuePair
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
