<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for isValidSchadensnummerNachnameRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request für Schadensnummer und Nachname überprüfung
 * @subpackage Structs
 */
class IsValidSchadensnummerNachnameRequest extends AbstractStructBase
{
    /**
     * The schadensnummer
     * @var string
     */
    public $schadensnummer;
    /**
     * The nachname
     * @var string
     */
    public $nachname;
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * Constructor method for isValidSchadensnummerNachnameRequest
     * @uses IsValidSchadensnummerNachnameRequest::setSchadensnummer()
     * @uses IsValidSchadensnummerNachnameRequest::setNachname()
     * @uses IsValidSchadensnummerNachnameRequest::setLogin()
     * @param string $schadensnummer
     * @param string $nachname
     * @param \StructType\Login $login
     */
    public function __construct($schadensnummer = null, $nachname = null, \StructType\Login $login = null)
    {
        $this
            ->setSchadensnummer($schadensnummer)
            ->setNachname($nachname)
            ->setLogin($login);
    }
    /**
     * Get schadensnummer value
     * @return string|null
     */
    public function getSchadensnummer()
    {
        return $this->schadensnummer;
    }
    /**
     * Set schadensnummer value
     * @param string $schadensnummer
     * @return \StructType\IsValidSchadensnummerNachnameRequest
     */
    public function setSchadensnummer($schadensnummer = null)
    {
        // validation for constraint: string
        if (!is_null($schadensnummer) && !is_string($schadensnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schadensnummer, true), gettype($schadensnummer)), __LINE__);
        }
        $this->schadensnummer = $schadensnummer;
        return $this;
    }
    /**
     * Get nachname value
     * @return string|null
     */
    public function getNachname()
    {
        return $this->nachname;
    }
    /**
     * Set nachname value
     * @param string $nachname
     * @return \StructType\IsValidSchadensnummerNachnameRequest
     */
    public function setNachname($nachname = null)
    {
        // validation for constraint: string
        if (!is_null($nachname) && !is_string($nachname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nachname, true), gettype($nachname)), __LINE__);
        }
        $this->nachname = $nachname;
        return $this;
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\IsValidSchadensnummerNachnameRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IsValidSchadensnummerNachnameRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
