<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for identifikationZuordnungType StructType
 * @subpackage Structs
 */
class IdentifikationZuordnungType extends AbstractStructBase
{
    /**
     * The regionaldirektion
     * @var string
     */
    public $regionaldirektion;
    /**
     * The geschaeftsstelle
     * @var string
     */
    public $geschaeftsstelle;
    /**
     * Constructor method for identifikationZuordnungType
     * @uses IdentifikationZuordnungType::setRegionaldirektion()
     * @uses IdentifikationZuordnungType::setGeschaeftsstelle()
     * @param string $regionaldirektion
     * @param string $geschaeftsstelle
     */
    public function __construct($regionaldirektion = null, $geschaeftsstelle = null)
    {
        $this
            ->setRegionaldirektion($regionaldirektion)
            ->setGeschaeftsstelle($geschaeftsstelle);
    }
    /**
     * Get regionaldirektion value
     * @return string|null
     */
    public function getRegionaldirektion()
    {
        return $this->regionaldirektion;
    }
    /**
     * Set regionaldirektion value
     * @uses \EnumType\RegionaldirektionType::valueIsValid()
     * @uses \EnumType\RegionaldirektionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $regionaldirektion
     * @return \StructType\IdentifikationZuordnungType
     */
    public function setRegionaldirektion($regionaldirektion = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RegionaldirektionType::valueIsValid($regionaldirektion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RegionaldirektionType', is_array($regionaldirektion) ? implode(', ', $regionaldirektion) : var_export($regionaldirektion, true), implode(', ', \EnumType\RegionaldirektionType::getValidValues())), __LINE__);
        }
        $this->regionaldirektion = $regionaldirektion;
        return $this;
    }
    /**
     * Get geschaeftsstelle value
     * @return string|null
     */
    public function getGeschaeftsstelle()
    {
        return $this->geschaeftsstelle;
    }
    /**
     * Set geschaeftsstelle value
     * @uses \EnumType\GeschaeftsstelleType::valueIsValid()
     * @uses \EnumType\GeschaeftsstelleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geschaeftsstelle
     * @return \StructType\IdentifikationZuordnungType
     */
    public function setGeschaeftsstelle($geschaeftsstelle = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GeschaeftsstelleType::valueIsValid($geschaeftsstelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GeschaeftsstelleType', is_array($geschaeftsstelle) ? implode(', ', $geschaeftsstelle) : var_export($geschaeftsstelle, true), implode(', ', \EnumType\GeschaeftsstelleType::getValidValues())), __LINE__);
        }
        $this->geschaeftsstelle = $geschaeftsstelle;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IdentifikationZuordnungType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
