<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HistoryEsam StructType
 * Meta information extracted from the WSDL
 * - documentation: Historyobjekt für eine Schadenmeldung
 * @subpackage Structs
 */
class HistoryEsam extends AbstractStructBase
{
    /**
     * The policyNumber
     * Meta information extracted from the WSDL
     * - documentation: Polizzennummer z.B. : 1/51/12345678 oder 1/51/12345678-01
     * - minOccurs: 0
     * @var string
     */
    public $policyNumber;
    /**
     * The claimNumber
     * Meta information extracted from the WSDL
     * - documentation: Schadennummer zum Geschäftsfall
     * - minOccurs: 0
     * @var string
     */
    public $claimNumber;
    /**
     * The claimRecordingNumber
     * Meta information extracted from the WSDL
     * - documentation: Schadenerfassungsnummer zum Geschäftsfall
     * - minOccurs: 0
     * @var string
     */
    public $claimRecordingNumber;
    /**
     * The abstractor
     * Meta information extracted from the WSDL
     * - documentation: Referent
     * - minOccurs: 0
     * @var \StructType\Abstractor
     */
    public $abstractor;
    /**
     * The recipient
     * Meta information extracted from the WSDL
     * - documentation: Empfänger
     * - minOccurs: 0
     * @var \StructType\Recipient
     */
    public $recipient;
    /**
     * Constructor method for HistoryEsam
     * @uses HistoryEsam::setPolicyNumber()
     * @uses HistoryEsam::setClaimNumber()
     * @uses HistoryEsam::setClaimRecordingNumber()
     * @uses HistoryEsam::setAbstractor()
     * @uses HistoryEsam::setRecipient()
     * @param string $policyNumber
     * @param string $claimNumber
     * @param string $claimRecordingNumber
     * @param \StructType\Abstractor $abstractor
     * @param \StructType\Recipient $recipient
     */
    public function __construct($policyNumber = null, $claimNumber = null, $claimRecordingNumber = null, \StructType\Abstractor $abstractor = null, \StructType\Recipient $recipient = null)
    {
        $this
            ->setPolicyNumber($policyNumber)
            ->setClaimNumber($claimNumber)
            ->setClaimRecordingNumber($claimRecordingNumber)
            ->setAbstractor($abstractor)
            ->setRecipient($recipient);
    }
    /**
     * Get policyNumber value
     * @return string|null
     */
    public function getPolicyNumber()
    {
        return $this->policyNumber;
    }
    /**
     * Set policyNumber value
     * @param string $policyNumber
     * @return \StructType\HistoryEsam
     */
    public function setPolicyNumber($policyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($policyNumber) && !is_string($policyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyNumber, true), gettype($policyNumber)), __LINE__);
        }
        $this->policyNumber = $policyNumber;
        return $this;
    }
    /**
     * Get claimNumber value
     * @return string|null
     */
    public function getClaimNumber()
    {
        return $this->claimNumber;
    }
    /**
     * Set claimNumber value
     * @param string $claimNumber
     * @return \StructType\HistoryEsam
     */
    public function setClaimNumber($claimNumber = null)
    {
        // validation for constraint: string
        if (!is_null($claimNumber) && !is_string($claimNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claimNumber, true), gettype($claimNumber)), __LINE__);
        }
        $this->claimNumber = $claimNumber;
        return $this;
    }
    /**
     * Get claimRecordingNumber value
     * @return string|null
     */
    public function getClaimRecordingNumber()
    {
        return $this->claimRecordingNumber;
    }
    /**
     * Set claimRecordingNumber value
     * @param string $claimRecordingNumber
     * @return \StructType\HistoryEsam
     */
    public function setClaimRecordingNumber($claimRecordingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($claimRecordingNumber) && !is_string($claimRecordingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claimRecordingNumber, true), gettype($claimRecordingNumber)), __LINE__);
        }
        $this->claimRecordingNumber = $claimRecordingNumber;
        return $this;
    }
    /**
     * Get abstractor value
     * @return \StructType\Abstractor|null
     */
    public function getAbstractor()
    {
        return $this->abstractor;
    }
    /**
     * Set abstractor value
     * @param \StructType\Abstractor $abstractor
     * @return \StructType\HistoryEsam
     */
    public function setAbstractor(\StructType\Abstractor $abstractor = null)
    {
        $this->abstractor = $abstractor;
        return $this;
    }
    /**
     * Get recipient value
     * @return \StructType\Recipient|null
     */
    public function getRecipient()
    {
        return $this->recipient;
    }
    /**
     * Set recipient value
     * @param \StructType\Recipient $recipient
     * @return \StructType\HistoryEsam
     */
    public function setRecipient(\StructType\Recipient $recipient = null)
    {
        $this->recipient = $recipient;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HistoryEsam
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
