<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for hasZeusDatenRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Request for asking if ZEUS daten does exist
 * @subpackage Structs
 */
class HasZeusDatenRequest extends AbstractStructBase
{
    /**
     * The licencePlate
     * Meta information extracted from the WSDL
     * - documentation: licence number of the car
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $licencePlate;
    /**
     * The login
     * Meta information extracted from the WSDL
     * - documentation: login data of user
     * @var \StructType\Login
     */
    public $login;
    /**
     * Constructor method for hasZeusDatenRequest
     * @uses HasZeusDatenRequest::setLicencePlate()
     * @uses HasZeusDatenRequest::setLogin()
     * @param string $licencePlate
     * @param \StructType\Login $login
     */
    public function __construct($licencePlate = null, \StructType\Login $login = null)
    {
        $this
            ->setLicencePlate($licencePlate)
            ->setLogin($login);
    }
    /**
     * Get licencePlate value
     * @return string
     */
    public function getLicencePlate()
    {
        return $this->licencePlate;
    }
    /**
     * Set licencePlate value
     * @param string $licencePlate
     * @return \StructType\HasZeusDatenRequest
     */
    public function setLicencePlate($licencePlate = null)
    {
        // validation for constraint: string
        if (!is_null($licencePlate) && !is_string($licencePlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licencePlate, true), gettype($licencePlate)), __LINE__);
        }
        $this->licencePlate = $licencePlate;
        return $this;
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\HasZeusDatenRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HasZeusDatenRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
