<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getBusinessCasesResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Liefert die Geschäftsfälle
 * @subpackage Structs
 */
class GetBusinessCasesResponse extends AbstractStructBase
{
    /**
     * The businessCases
     * Meta information extracted from the WSDL
     * - maxOccurs: 50
     * - minOccurs: 0
     * @var \StructType\BusinessCase[]
     */
    public $businessCases;
    /**
     * The evpServiceFault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EvpServiceFault
     */
    public $evpServiceFault;
    /**
     * The realCount
     * Meta information extracted from the WSDL
     * - documentation: Gesamtanzahl der anzuholenden Geschäftsfälle
     * @var int
     */
    public $realCount;
    /**
     * The count
     * Meta information extracted from the WSDL
     * - documentation: Gesamtanzahl der Geschäftsfälle im Response
     * @var int
     */
    public $count;
    /**
     * Constructor method for getBusinessCasesResponse
     * @uses GetBusinessCasesResponse::setBusinessCases()
     * @uses GetBusinessCasesResponse::setEvpServiceFault()
     * @uses GetBusinessCasesResponse::setRealCount()
     * @uses GetBusinessCasesResponse::setCount()
     * @param \StructType\BusinessCase[] $businessCases
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @param int $realCount
     * @param int $count
     */
    public function __construct(array $businessCases = array(), \StructType\EvpServiceFault $evpServiceFault = null, $realCount = null, $count = null)
    {
        $this
            ->setBusinessCases($businessCases)
            ->setEvpServiceFault($evpServiceFault)
            ->setRealCount($realCount)
            ->setCount($count);
    }
    /**
     * Get businessCases value
     * @return \StructType\BusinessCase[]|null
     */
    public function getBusinessCases()
    {
        return $this->businessCases;
    }
    /**
     * This method is responsible for validating the values passed to the setBusinessCases method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusinessCases method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusinessCasesForArrayConstraintsFromSetBusinessCases(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getBusinessCasesResponseBusinessCasesItem) {
            // validation for constraint: itemType
            if (!$getBusinessCasesResponseBusinessCasesItem instanceof \StructType\BusinessCase) {
                $invalidValues[] = is_object($getBusinessCasesResponseBusinessCasesItem) ? get_class($getBusinessCasesResponseBusinessCasesItem) : sprintf('%s(%s)', gettype($getBusinessCasesResponseBusinessCasesItem), var_export($getBusinessCasesResponseBusinessCasesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The businessCases property can only contain items of type \StructType\BusinessCase, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set businessCases value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessCase[] $businessCases
     * @return \StructType\GetBusinessCasesResponse
     */
    public function setBusinessCases(array $businessCases = array())
    {
        // validation for constraint: array
        if ('' !== ($businessCasesArrayErrorMessage = self::validateBusinessCasesForArrayConstraintsFromSetBusinessCases($businessCases))) {
            throw new \InvalidArgumentException($businessCasesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($businessCases) && count($businessCases) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 50', count($businessCases)), __LINE__);
        }
        $this->businessCases = $businessCases;
        return $this;
    }
    /**
     * Add item to businessCases value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessCase $item
     * @return \StructType\GetBusinessCasesResponse
     */
    public function addToBusinessCases(\StructType\BusinessCase $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BusinessCase) {
            throw new \InvalidArgumentException(sprintf('The businessCases property can only contain items of type \StructType\BusinessCase, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($this->businessCases) && count($this->businessCases) >= 50) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 50', count($this->businessCases)), __LINE__);
        }
        $this->businessCases[] = $item;
        return $this;
    }
    /**
     * Get evpServiceFault value
     * @return \StructType\EvpServiceFault|null
     */
    public function getEvpServiceFault()
    {
        return $this->evpServiceFault;
    }
    /**
     * Set evpServiceFault value
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @return \StructType\GetBusinessCasesResponse
     */
    public function setEvpServiceFault(\StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this->evpServiceFault = $evpServiceFault;
        return $this;
    }
    /**
     * Get realCount value
     * @return int|null
     */
    public function getRealCount()
    {
        return $this->realCount;
    }
    /**
     * Set realCount value
     * @param int $realCount
     * @return \StructType\GetBusinessCasesResponse
     */
    public function setRealCount($realCount = null)
    {
        // validation for constraint: int
        if (!is_null($realCount) && !(is_int($realCount) || ctype_digit($realCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($realCount, true), gettype($realCount)), __LINE__);
        }
        $this->realCount = $realCount;
        return $this;
    }
    /**
     * Get count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\GetBusinessCasesResponse
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetBusinessCasesResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
