<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getBusinessCaseTypesResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: Repsonse returns an array of businesscase types
 * @subpackage Structs
 */
class GetBusinessCaseTypesResponse extends AbstractStructBase
{
    /**
     * The businessCaseType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $businessCaseType;
    /**
     * The evpServiceFault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EvpServiceFault
     */
    public $evpServiceFault;
    /**
     * Constructor method for getBusinessCaseTypesResponse
     * @uses GetBusinessCaseTypesResponse::setBusinessCaseType()
     * @uses GetBusinessCaseTypesResponse::setEvpServiceFault()
     * @param string[] $businessCaseType
     * @param \StructType\EvpServiceFault $evpServiceFault
     */
    public function __construct(array $businessCaseType = array(), \StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this
            ->setBusinessCaseType($businessCaseType)
            ->setEvpServiceFault($evpServiceFault);
    }
    /**
     * Get businessCaseType value
     * @return string[]|null
     */
    public function getBusinessCaseType()
    {
        return $this->businessCaseType;
    }
    /**
     * This method is responsible for validating the values passed to the setBusinessCaseType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusinessCaseType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusinessCaseTypeForArrayConstraintsFromSetBusinessCaseType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getBusinessCaseTypesResponseBusinessCaseTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\BusinessCaseType::valueIsValid($getBusinessCaseTypesResponseBusinessCaseTypeItem)) {
                $invalidValues[] = is_object($getBusinessCaseTypesResponseBusinessCaseTypeItem) ? get_class($getBusinessCaseTypesResponseBusinessCaseTypeItem) : sprintf('%s(%s)', gettype($getBusinessCaseTypesResponseBusinessCaseTypeItem), var_export($getBusinessCaseTypesResponseBusinessCaseTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BusinessCaseType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\BusinessCaseType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set businessCaseType value
     * @uses \EnumType\BusinessCaseType::valueIsValid()
     * @uses \EnumType\BusinessCaseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $businessCaseType
     * @return \StructType\GetBusinessCaseTypesResponse
     */
    public function setBusinessCaseType(array $businessCaseType = array())
    {
        // validation for constraint: array
        if ('' !== ($businessCaseTypeArrayErrorMessage = self::validateBusinessCaseTypeForArrayConstraintsFromSetBusinessCaseType($businessCaseType))) {
            throw new \InvalidArgumentException($businessCaseTypeArrayErrorMessage, __LINE__);
        }
        $this->businessCaseType = $businessCaseType;
        return $this;
    }
    /**
     * Add item to businessCaseType value
     * @uses \EnumType\BusinessCaseType::valueIsValid()
     * @uses \EnumType\BusinessCaseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GetBusinessCaseTypesResponse
     */
    public function addToBusinessCaseType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusinessCaseType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BusinessCaseType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\BusinessCaseType::getValidValues())), __LINE__);
        }
        $this->businessCaseType[] = $item;
        return $this;
    }
    /**
     * Get evpServiceFault value
     * @return \StructType\EvpServiceFault|null
     */
    public function getEvpServiceFault()
    {
        return $this->evpServiceFault;
    }
    /**
     * Set evpServiceFault value
     * @param \StructType\EvpServiceFault $evpServiceFault
     * @return \StructType\GetBusinessCaseTypesResponse
     */
    public function setEvpServiceFault(\StructType\EvpServiceFault $evpServiceFault = null)
    {
        $this->evpServiceFault = $evpServiceFault;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetBusinessCaseTypesResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
