<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createOrUpdatePartnerContactRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Erstellt oder aktualisert einen Partnerkontakt eines PA-Partners
 * @subpackage Structs
 */
class CreateOrUpdatePartnerContactRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The paoid
     * @var string
     */
    public $paoid;
    /**
     * The contactReason
     * @var string
     */
    public $contactReason;
    /**
     * The subject
     * Meta information extracted from the WSDL
     * - documentation: Maximal 30 Stellen. Überstände werden abgeschnitten
     * @var string
     */
    public $subject;
    /**
     * The text
     * Meta information extracted from the WSDL
     * - documentation: Maximal 500 Stellen. Überstände werden abgeschnitten
     * @var string
     */
    public $text;
    /**
     * Constructor method for createOrUpdatePartnerContactRequest
     * @uses CreateOrUpdatePartnerContactRequest::setLogin()
     * @uses CreateOrUpdatePartnerContactRequest::setPaoid()
     * @uses CreateOrUpdatePartnerContactRequest::setContactReason()
     * @uses CreateOrUpdatePartnerContactRequest::setSubject()
     * @uses CreateOrUpdatePartnerContactRequest::setText()
     * @param \StructType\Login $login
     * @param string $paoid
     * @param string $contactReason
     * @param string $subject
     * @param string $text
     */
    public function __construct(\StructType\Login $login = null, $paoid = null, $contactReason = null, $subject = null, $text = null)
    {
        $this
            ->setLogin($login)
            ->setPaoid($paoid)
            ->setContactReason($contactReason)
            ->setSubject($subject)
            ->setText($text);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\CreateOrUpdatePartnerContactRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get paoid value
     * @return string|null
     */
    public function getPaoid()
    {
        return $this->paoid;
    }
    /**
     * Set paoid value
     * @param string $paoid
     * @return \StructType\CreateOrUpdatePartnerContactRequest
     */
    public function setPaoid($paoid = null)
    {
        // validation for constraint: string
        if (!is_null($paoid) && !is_string($paoid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paoid, true), gettype($paoid)), __LINE__);
        }
        $this->paoid = $paoid;
        return $this;
    }
    /**
     * Get contactReason value
     * @return string|null
     */
    public function getContactReason()
    {
        return $this->contactReason;
    }
    /**
     * Set contactReason value
     * @uses \EnumType\ContactReason::valueIsValid()
     * @uses \EnumType\ContactReason::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contactReason
     * @return \StructType\CreateOrUpdatePartnerContactRequest
     */
    public function setContactReason($contactReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContactReason::valueIsValid($contactReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ContactReason', is_array($contactReason) ? implode(', ', $contactReason) : var_export($contactReason, true), implode(', ', \EnumType\ContactReason::getValidValues())), __LINE__);
        }
        $this->contactReason = $contactReason;
        return $this;
    }
    /**
     * Get subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->subject;
    }
    /**
     * Set subject value
     * @param string $subject
     * @return \StructType\CreateOrUpdatePartnerContactRequest
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subject, true), gettype($subject)), __LINE__);
        }
        $this->subject = $subject;
        return $this;
    }
    /**
     * Get text value
     * @return string|null
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \StructType\CreateOrUpdatePartnerContactRequest
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateOrUpdatePartnerContactRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
