<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContractSearchDetail StructType
 * Meta information extracted from the WSDL
 * - documentation: Vertragssuche Result Detail
 * @subpackage Structs
 */
class ContractSearchDetail extends AbstractStructBase
{
    /**
     * The kran
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $kran;
    /**
     * The pzWithAdress
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $pzWithAdress;
    /**
     * The policy
     * @var \StructType\Policy
     */
    public $policy;
    /**
     * The policyHolderName
     * Meta information extracted from the WSDL
     * - documentation: Nachname des Versicherungsnehmers
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $policyHolderName;
    /**
     * The policyHolderFirstName
     * Meta information extracted from the WSDL
     * - documentation: Vorname des Versicherungsnehmers
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $policyHolderFirstName;
    /**
     * The policyHolderZip
     * Meta information extracted from the WSDL
     * - documentation: Postleitzahl Addresse Versicherungsnehmer
     * @var int
     */
    public $policyHolderZip;
    /**
     * The policyHolderCity
     * Meta information extracted from the WSDL
     * - documentation: Ort Addresse Versicherungsnehmer
     * @var string
     */
    public $policyHolderCity;
    /**
     * The state
     * @var string
     */
    public $state;
    /**
     * The businessCaseType
     * Meta information extracted from the WSDL
     * - documentation: Beratungstyp
     * @var string
     */
    public $businessCaseType;
    /**
     * The policyBegin
     * Meta information extracted from the WSDL
     * - documentation: Versicherungsbeginn
     * @var string
     */
    public $policyBegin;
    /**
     * The policyPremium
     * Meta information extracted from the WSDL
     * - documentation: Bruttojahresprämie
     * @var float
     */
    public $policyPremium;
    /**
     * The policyPremiumPaymentFrequency
     * Meta information extracted from the WSDL
     * - documentation: Prämie laut Zahlungsweise
     * @var float
     */
    public $policyPremiumPaymentFrequency;
    /**
     * The policyNote
     * Meta information extracted from the WSDL
     * - documentation: Anmerkung zur Polizze
     * @var string
     */
    public $policyNote;
    /**
     * The policyTypeFull
     * Meta information extracted from the WSDL
     * - documentation: Polizzenlangtext
     * @var string
     */
    public $policyTypeFull;
    /**
     * The betrVersArt
     * Meta information extracted from the WSDL
     * - documentation: Praemienzahler PAOID
     * @var string
     */
    public $betrVersArt;
    /**
     * The betrVersDirekt
     * Meta information extracted from the WSDL
     * - documentation: Praemienzahler PAOID
     * @var string
     */
    public $betrVersDirekt;
    /**
     * The vvd
     * @var bool
     */
    public $vvd;
    /**
     * The partnerRoles
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PolicyPartnerRole[]
     */
    public $partnerRoles;
    /**
     * The inkassoAdresse
     * @var string
     */
    public $inkassoAdresse;
    /**
     * The inkassoBank
     * @var string
     */
    public $inkassoBank;
    /**
     * The pwn_assistance
     * Meta information extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $pwn_assistance;
    /**
     * The rvPolnr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rvPolnr;
    /**
     * The zahlungsRueckstandBetrag
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $zahlungsRueckstandBetrag;
    /**
     * The hasCyberDeckung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $hasCyberDeckung;
    /**
     * The hasBeratungRS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $hasBeratungRS;
    /**
     * The detailInfoAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $detailInfoAvailable;
    /**
     * The detailInfoAvailableMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $detailInfoAvailableMessage;
    /**
     * The claimCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $claimCategory;
    /**
     * The arztAkut
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $arztAkut;
    /**
     * The virtSprechArzt
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $virtSprechArzt;
    /**
     * The virtSprechCoach
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $virtSprechCoach;
    /**
     * The suchenBuchen
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $suchenBuchen;
    /**
     * The gesundCoach
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $gesundCoach;
    /**
     * The hasRundumGesund
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $hasRundumGesund;
    /**
     * Constructor method for ContractSearchDetail
     * @uses ContractSearchDetail::setKran()
     * @uses ContractSearchDetail::setPzWithAdress()
     * @uses ContractSearchDetail::setPolicy()
     * @uses ContractSearchDetail::setPolicyHolderName()
     * @uses ContractSearchDetail::setPolicyHolderFirstName()
     * @uses ContractSearchDetail::setPolicyHolderZip()
     * @uses ContractSearchDetail::setPolicyHolderCity()
     * @uses ContractSearchDetail::setState()
     * @uses ContractSearchDetail::setBusinessCaseType()
     * @uses ContractSearchDetail::setPolicyBegin()
     * @uses ContractSearchDetail::setPolicyPremium()
     * @uses ContractSearchDetail::setPolicyPremiumPaymentFrequency()
     * @uses ContractSearchDetail::setPolicyNote()
     * @uses ContractSearchDetail::setPolicyTypeFull()
     * @uses ContractSearchDetail::setBetrVersArt()
     * @uses ContractSearchDetail::setBetrVersDirekt()
     * @uses ContractSearchDetail::setVvd()
     * @uses ContractSearchDetail::setPartnerRoles()
     * @uses ContractSearchDetail::setInkassoAdresse()
     * @uses ContractSearchDetail::setInkassoBank()
     * @uses ContractSearchDetail::setPwn_assistance()
     * @uses ContractSearchDetail::setRvPolnr()
     * @uses ContractSearchDetail::setZahlungsRueckstandBetrag()
     * @uses ContractSearchDetail::setHasCyberDeckung()
     * @uses ContractSearchDetail::setHasBeratungRS()
     * @uses ContractSearchDetail::setDetailInfoAvailable()
     * @uses ContractSearchDetail::setDetailInfoAvailableMessage()
     * @uses ContractSearchDetail::setClaimCategory()
     * @uses ContractSearchDetail::setArztAkut()
     * @uses ContractSearchDetail::setVirtSprechArzt()
     * @uses ContractSearchDetail::setVirtSprechCoach()
     * @uses ContractSearchDetail::setSuchenBuchen()
     * @uses ContractSearchDetail::setGesundCoach()
     * @uses ContractSearchDetail::setHasRundumGesund()
     * @param bool $kran
     * @param bool $pzWithAdress
     * @param \StructType\Policy $policy
     * @param string $policyHolderName
     * @param string $policyHolderFirstName
     * @param int $policyHolderZip
     * @param string $policyHolderCity
     * @param string $state
     * @param string $businessCaseType
     * @param string $policyBegin
     * @param float $policyPremium
     * @param float $policyPremiumPaymentFrequency
     * @param string $policyNote
     * @param string $policyTypeFull
     * @param string $betrVersArt
     * @param string $betrVersDirekt
     * @param bool $vvd
     * @param \StructType\PolicyPartnerRole[] $partnerRoles
     * @param string $inkassoAdresse
     * @param string $inkassoBank
     * @param bool $pwn_assistance
     * @param string $rvPolnr
     * @param float $zahlungsRueckstandBetrag
     * @param bool $hasCyberDeckung
     * @param bool $hasBeratungRS
     * @param bool $detailInfoAvailable
     * @param string $detailInfoAvailableMessage
     * @param string[] $claimCategory
     * @param bool $arztAkut
     * @param bool $virtSprechArzt
     * @param bool $virtSprechCoach
     * @param bool $suchenBuchen
     * @param bool $gesundCoach
     * @param bool $hasRundumGesund
     */
    public function __construct($kran = false, $pzWithAdress = false, \StructType\Policy $policy = null, $policyHolderName = null, $policyHolderFirstName = null, $policyHolderZip = null, $policyHolderCity = null, $state = null, $businessCaseType = null, $policyBegin = null, $policyPremium = null, $policyPremiumPaymentFrequency = null, $policyNote = null, $policyTypeFull = null, $betrVersArt = null, $betrVersDirekt = null, $vvd = null, array $partnerRoles = array(), $inkassoAdresse = null, $inkassoBank = null, $pwn_assistance = false, $rvPolnr = null, $zahlungsRueckstandBetrag = null, $hasCyberDeckung = null, $hasBeratungRS = null, $detailInfoAvailable = null, $detailInfoAvailableMessage = null, array $claimCategory = array(), $arztAkut = false, $virtSprechArzt = false, $virtSprechCoach = false, $suchenBuchen = false, $gesundCoach = false, $hasRundumGesund = null)
    {
        $this
            ->setKran($kran)
            ->setPzWithAdress($pzWithAdress)
            ->setPolicy($policy)
            ->setPolicyHolderName($policyHolderName)
            ->setPolicyHolderFirstName($policyHolderFirstName)
            ->setPolicyHolderZip($policyHolderZip)
            ->setPolicyHolderCity($policyHolderCity)
            ->setState($state)
            ->setBusinessCaseType($businessCaseType)
            ->setPolicyBegin($policyBegin)
            ->setPolicyPremium($policyPremium)
            ->setPolicyPremiumPaymentFrequency($policyPremiumPaymentFrequency)
            ->setPolicyNote($policyNote)
            ->setPolicyTypeFull($policyTypeFull)
            ->setBetrVersArt($betrVersArt)
            ->setBetrVersDirekt($betrVersDirekt)
            ->setVvd($vvd)
            ->setPartnerRoles($partnerRoles)
            ->setInkassoAdresse($inkassoAdresse)
            ->setInkassoBank($inkassoBank)
            ->setPwn_assistance($pwn_assistance)
            ->setRvPolnr($rvPolnr)
            ->setZahlungsRueckstandBetrag($zahlungsRueckstandBetrag)
            ->setHasCyberDeckung($hasCyberDeckung)
            ->setHasBeratungRS($hasBeratungRS)
            ->setDetailInfoAvailable($detailInfoAvailable)
            ->setDetailInfoAvailableMessage($detailInfoAvailableMessage)
            ->setClaimCategory($claimCategory)
            ->setArztAkut($arztAkut)
            ->setVirtSprechArzt($virtSprechArzt)
            ->setVirtSprechCoach($virtSprechCoach)
            ->setSuchenBuchen($suchenBuchen)
            ->setGesundCoach($gesundCoach)
            ->setHasRundumGesund($hasRundumGesund);
    }
    /**
     * Get kran value
     * @return bool
     */
    public function getKran()
    {
        return $this->kran;
    }
    /**
     * Set kran value
     * @param bool $kran
     * @return \StructType\ContractSearchDetail
     */
    public function setKran($kran = false)
    {
        // validation for constraint: boolean
        if (!is_null($kran) && !is_bool($kran)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kran, true), gettype($kran)), __LINE__);
        }
        $this->kran = $kran;
        return $this;
    }
    /**
     * Get pzWithAdress value
     * @return bool
     */
    public function getPzWithAdress()
    {
        return $this->pzWithAdress;
    }
    /**
     * Set pzWithAdress value
     * @param bool $pzWithAdress
     * @return \StructType\ContractSearchDetail
     */
    public function setPzWithAdress($pzWithAdress = false)
    {
        // validation for constraint: boolean
        if (!is_null($pzWithAdress) && !is_bool($pzWithAdress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pzWithAdress, true), gettype($pzWithAdress)), __LINE__);
        }
        $this->pzWithAdress = $pzWithAdress;
        return $this;
    }
    /**
     * Get policy value
     * @return \StructType\Policy|null
     */
    public function getPolicy()
    {
        return $this->policy;
    }
    /**
     * Set policy value
     * @param \StructType\Policy $policy
     * @return \StructType\ContractSearchDetail
     */
    public function setPolicy(\StructType\Policy $policy = null)
    {
        $this->policy = $policy;
        return $this;
    }
    /**
     * Get policyHolderName value
     * @return string|null
     */
    public function getPolicyHolderName()
    {
        return $this->policyHolderName;
    }
    /**
     * Set policyHolderName value
     * @param string $policyHolderName
     * @return \StructType\ContractSearchDetail
     */
    public function setPolicyHolderName($policyHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($policyHolderName) && !is_string($policyHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyHolderName, true), gettype($policyHolderName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($policyHolderName) && mb_strlen($policyHolderName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($policyHolderName)), __LINE__);
        }
        $this->policyHolderName = $policyHolderName;
        return $this;
    }
    /**
     * Get policyHolderFirstName value
     * @return string|null
     */
    public function getPolicyHolderFirstName()
    {
        return $this->policyHolderFirstName;
    }
    /**
     * Set policyHolderFirstName value
     * @param string $policyHolderFirstName
     * @return \StructType\ContractSearchDetail
     */
    public function setPolicyHolderFirstName($policyHolderFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($policyHolderFirstName) && !is_string($policyHolderFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyHolderFirstName, true), gettype($policyHolderFirstName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($policyHolderFirstName) && mb_strlen($policyHolderFirstName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($policyHolderFirstName)), __LINE__);
        }
        $this->policyHolderFirstName = $policyHolderFirstName;
        return $this;
    }
    /**
     * Get policyHolderZip value
     * @return int|null
     */
    public function getPolicyHolderZip()
    {
        return $this->policyHolderZip;
    }
    /**
     * Set policyHolderZip value
     * @param int $policyHolderZip
     * @return \StructType\ContractSearchDetail
     */
    public function setPolicyHolderZip($policyHolderZip = null)
    {
        // validation for constraint: int
        if (!is_null($policyHolderZip) && !(is_int($policyHolderZip) || ctype_digit($policyHolderZip))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($policyHolderZip, true), gettype($policyHolderZip)), __LINE__);
        }
        $this->policyHolderZip = $policyHolderZip;
        return $this;
    }
    /**
     * Get policyHolderCity value
     * @return string|null
     */
    public function getPolicyHolderCity()
    {
        return $this->policyHolderCity;
    }
    /**
     * Set policyHolderCity value
     * @param string $policyHolderCity
     * @return \StructType\ContractSearchDetail
     */
    public function setPolicyHolderCity($policyHolderCity = null)
    {
        // validation for constraint: string
        if (!is_null($policyHolderCity) && !is_string($policyHolderCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyHolderCity, true), gettype($policyHolderCity)), __LINE__);
        }
        $this->policyHolderCity = $policyHolderCity;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @uses \EnumType\State::valueIsValid()
     * @uses \EnumType\State::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \StructType\ContractSearchDetail
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\State::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\State', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \EnumType\State::getValidValues())), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get businessCaseType value
     * @return string|null
     */
    public function getBusinessCaseType()
    {
        return $this->businessCaseType;
    }
    /**
     * Set businessCaseType value
     * @uses \EnumType\BusinessCaseType::valueIsValid()
     * @uses \EnumType\BusinessCaseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $businessCaseType
     * @return \StructType\ContractSearchDetail
     */
    public function setBusinessCaseType($businessCaseType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusinessCaseType::valueIsValid($businessCaseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BusinessCaseType', is_array($businessCaseType) ? implode(', ', $businessCaseType) : var_export($businessCaseType, true), implode(', ', \EnumType\BusinessCaseType::getValidValues())), __LINE__);
        }
        $this->businessCaseType = $businessCaseType;
        return $this;
    }
    /**
     * Get policyBegin value
     * @return string|null
     */
    public function getPolicyBegin()
    {
        return $this->policyBegin;
    }
    /**
     * Set policyBegin value
     * @param string $policyBegin
     * @return \StructType\ContractSearchDetail
     */
    public function setPolicyBegin($policyBegin = null)
    {
        // validation for constraint: string
        if (!is_null($policyBegin) && !is_string($policyBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyBegin, true), gettype($policyBegin)), __LINE__);
        }
        $this->policyBegin = $policyBegin;
        return $this;
    }
    /**
     * Get policyPremium value
     * @return float|null
     */
    public function getPolicyPremium()
    {
        return $this->policyPremium;
    }
    /**
     * Set policyPremium value
     * @param float $policyPremium
     * @return \StructType\ContractSearchDetail
     */
    public function setPolicyPremium($policyPremium = null)
    {
        // validation for constraint: float
        if (!is_null($policyPremium) && !(is_float($policyPremium) || is_numeric($policyPremium))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($policyPremium, true), gettype($policyPremium)), __LINE__);
        }
        $this->policyPremium = $policyPremium;
        return $this;
    }
    /**
     * Get policyPremiumPaymentFrequency value
     * @return float|null
     */
    public function getPolicyPremiumPaymentFrequency()
    {
        return $this->policyPremiumPaymentFrequency;
    }
    /**
     * Set policyPremiumPaymentFrequency value
     * @param float $policyPremiumPaymentFrequency
     * @return \StructType\ContractSearchDetail
     */
    public function setPolicyPremiumPaymentFrequency($policyPremiumPaymentFrequency = null)
    {
        // validation for constraint: float
        if (!is_null($policyPremiumPaymentFrequency) && !(is_float($policyPremiumPaymentFrequency) || is_numeric($policyPremiumPaymentFrequency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($policyPremiumPaymentFrequency, true), gettype($policyPremiumPaymentFrequency)), __LINE__);
        }
        $this->policyPremiumPaymentFrequency = $policyPremiumPaymentFrequency;
        return $this;
    }
    /**
     * Get policyNote value
     * @return string|null
     */
    public function getPolicyNote()
    {
        return $this->policyNote;
    }
    /**
     * Set policyNote value
     * @param string $policyNote
     * @return \StructType\ContractSearchDetail
     */
    public function setPolicyNote($policyNote = null)
    {
        // validation for constraint: string
        if (!is_null($policyNote) && !is_string($policyNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyNote, true), gettype($policyNote)), __LINE__);
        }
        $this->policyNote = $policyNote;
        return $this;
    }
    /**
     * Get policyTypeFull value
     * @return string|null
     */
    public function getPolicyTypeFull()
    {
        return $this->policyTypeFull;
    }
    /**
     * Set policyTypeFull value
     * @param string $policyTypeFull
     * @return \StructType\ContractSearchDetail
     */
    public function setPolicyTypeFull($policyTypeFull = null)
    {
        // validation for constraint: string
        if (!is_null($policyTypeFull) && !is_string($policyTypeFull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyTypeFull, true), gettype($policyTypeFull)), __LINE__);
        }
        $this->policyTypeFull = $policyTypeFull;
        return $this;
    }
    /**
     * Get betrVersArt value
     * @return string|null
     */
    public function getBetrVersArt()
    {
        return $this->betrVersArt;
    }
    /**
     * Set betrVersArt value
     * @param string $betrVersArt
     * @return \StructType\ContractSearchDetail
     */
    public function setBetrVersArt($betrVersArt = null)
    {
        // validation for constraint: string
        if (!is_null($betrVersArt) && !is_string($betrVersArt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($betrVersArt, true), gettype($betrVersArt)), __LINE__);
        }
        $this->betrVersArt = $betrVersArt;
        return $this;
    }
    /**
     * Get betrVersDirekt value
     * @return string|null
     */
    public function getBetrVersDirekt()
    {
        return $this->betrVersDirekt;
    }
    /**
     * Set betrVersDirekt value
     * @param string $betrVersDirekt
     * @return \StructType\ContractSearchDetail
     */
    public function setBetrVersDirekt($betrVersDirekt = null)
    {
        // validation for constraint: string
        if (!is_null($betrVersDirekt) && !is_string($betrVersDirekt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($betrVersDirekt, true), gettype($betrVersDirekt)), __LINE__);
        }
        $this->betrVersDirekt = $betrVersDirekt;
        return $this;
    }
    /**
     * Get vvd value
     * @return bool|null
     */
    public function getVvd()
    {
        return $this->vvd;
    }
    /**
     * Set vvd value
     * @param bool $vvd
     * @return \StructType\ContractSearchDetail
     */
    public function setVvd($vvd = null)
    {
        // validation for constraint: boolean
        if (!is_null($vvd) && !is_bool($vvd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vvd, true), gettype($vvd)), __LINE__);
        }
        $this->vvd = $vvd;
        return $this;
    }
    /**
     * Get partnerRoles value
     * @return \StructType\PolicyPartnerRole[]|null
     */
    public function getPartnerRoles()
    {
        return $this->partnerRoles;
    }
    /**
     * This method is responsible for validating the values passed to the setPartnerRoles method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartnerRoles method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartnerRolesForArrayConstraintsFromSetPartnerRoles(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contractSearchDetailPartnerRolesItem) {
            // validation for constraint: itemType
            if (!$contractSearchDetailPartnerRolesItem instanceof \StructType\PolicyPartnerRole) {
                $invalidValues[] = is_object($contractSearchDetailPartnerRolesItem) ? get_class($contractSearchDetailPartnerRolesItem) : sprintf('%s(%s)', gettype($contractSearchDetailPartnerRolesItem), var_export($contractSearchDetailPartnerRolesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The partnerRoles property can only contain items of type \StructType\PolicyPartnerRole, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set partnerRoles value
     * @throws \InvalidArgumentException
     * @param \StructType\PolicyPartnerRole[] $partnerRoles
     * @return \StructType\ContractSearchDetail
     */
    public function setPartnerRoles(array $partnerRoles = array())
    {
        // validation for constraint: array
        if ('' !== ($partnerRolesArrayErrorMessage = self::validatePartnerRolesForArrayConstraintsFromSetPartnerRoles($partnerRoles))) {
            throw new \InvalidArgumentException($partnerRolesArrayErrorMessage, __LINE__);
        }
        $this->partnerRoles = $partnerRoles;
        return $this;
    }
    /**
     * Add item to partnerRoles value
     * @throws \InvalidArgumentException
     * @param \StructType\PolicyPartnerRole $item
     * @return \StructType\ContractSearchDetail
     */
    public function addToPartnerRoles(\StructType\PolicyPartnerRole $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PolicyPartnerRole) {
            throw new \InvalidArgumentException(sprintf('The partnerRoles property can only contain items of type \StructType\PolicyPartnerRole, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->partnerRoles[] = $item;
        return $this;
    }
    /**
     * Get inkassoAdresse value
     * @return string|null
     */
    public function getInkassoAdresse()
    {
        return $this->inkassoAdresse;
    }
    /**
     * Set inkassoAdresse value
     * @param string $inkassoAdresse
     * @return \StructType\ContractSearchDetail
     */
    public function setInkassoAdresse($inkassoAdresse = null)
    {
        // validation for constraint: string
        if (!is_null($inkassoAdresse) && !is_string($inkassoAdresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inkassoAdresse, true), gettype($inkassoAdresse)), __LINE__);
        }
        $this->inkassoAdresse = $inkassoAdresse;
        return $this;
    }
    /**
     * Get inkassoBank value
     * @return string|null
     */
    public function getInkassoBank()
    {
        return $this->inkassoBank;
    }
    /**
     * Set inkassoBank value
     * @param string $inkassoBank
     * @return \StructType\ContractSearchDetail
     */
    public function setInkassoBank($inkassoBank = null)
    {
        // validation for constraint: string
        if (!is_null($inkassoBank) && !is_string($inkassoBank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inkassoBank, true), gettype($inkassoBank)), __LINE__);
        }
        $this->inkassoBank = $inkassoBank;
        return $this;
    }
    /**
     * Get pwn_assistance value
     * @return bool|null
     */
    public function getPwn_assistance()
    {
        return $this->pwn_assistance;
    }
    /**
     * Set pwn_assistance value
     * @param bool $pwn_assistance
     * @return \StructType\ContractSearchDetail
     */
    public function setPwn_assistance($pwn_assistance = false)
    {
        // validation for constraint: boolean
        if (!is_null($pwn_assistance) && !is_bool($pwn_assistance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pwn_assistance, true), gettype($pwn_assistance)), __LINE__);
        }
        $this->pwn_assistance = $pwn_assistance;
        return $this;
    }
    /**
     * Get rvPolnr value
     * @return string|null
     */
    public function getRvPolnr()
    {
        return $this->rvPolnr;
    }
    /**
     * Set rvPolnr value
     * @param string $rvPolnr
     * @return \StructType\ContractSearchDetail
     */
    public function setRvPolnr($rvPolnr = null)
    {
        // validation for constraint: string
        if (!is_null($rvPolnr) && !is_string($rvPolnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rvPolnr, true), gettype($rvPolnr)), __LINE__);
        }
        $this->rvPolnr = $rvPolnr;
        return $this;
    }
    /**
     * Get zahlungsRueckstandBetrag value
     * @return float|null
     */
    public function getZahlungsRueckstandBetrag()
    {
        return $this->zahlungsRueckstandBetrag;
    }
    /**
     * Set zahlungsRueckstandBetrag value
     * @param float $zahlungsRueckstandBetrag
     * @return \StructType\ContractSearchDetail
     */
    public function setZahlungsRueckstandBetrag($zahlungsRueckstandBetrag = null)
    {
        // validation for constraint: float
        if (!is_null($zahlungsRueckstandBetrag) && !(is_float($zahlungsRueckstandBetrag) || is_numeric($zahlungsRueckstandBetrag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($zahlungsRueckstandBetrag, true), gettype($zahlungsRueckstandBetrag)), __LINE__);
        }
        $this->zahlungsRueckstandBetrag = $zahlungsRueckstandBetrag;
        return $this;
    }
    /**
     * Get hasCyberDeckung value
     * @return bool|null
     */
    public function getHasCyberDeckung()
    {
        return $this->hasCyberDeckung;
    }
    /**
     * Set hasCyberDeckung value
     * @param bool $hasCyberDeckung
     * @return \StructType\ContractSearchDetail
     */
    public function setHasCyberDeckung($hasCyberDeckung = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasCyberDeckung) && !is_bool($hasCyberDeckung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasCyberDeckung, true), gettype($hasCyberDeckung)), __LINE__);
        }
        $this->hasCyberDeckung = $hasCyberDeckung;
        return $this;
    }
    /**
     * Get hasBeratungRS value
     * @return bool|null
     */
    public function getHasBeratungRS()
    {
        return $this->hasBeratungRS;
    }
    /**
     * Set hasBeratungRS value
     * @param bool $hasBeratungRS
     * @return \StructType\ContractSearchDetail
     */
    public function setHasBeratungRS($hasBeratungRS = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasBeratungRS) && !is_bool($hasBeratungRS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasBeratungRS, true), gettype($hasBeratungRS)), __LINE__);
        }
        $this->hasBeratungRS = $hasBeratungRS;
        return $this;
    }
    /**
     * Get detailInfoAvailable value
     * @return bool|null
     */
    public function getDetailInfoAvailable()
    {
        return $this->detailInfoAvailable;
    }
    /**
     * Set detailInfoAvailable value
     * @param bool $detailInfoAvailable
     * @return \StructType\ContractSearchDetail
     */
    public function setDetailInfoAvailable($detailInfoAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($detailInfoAvailable) && !is_bool($detailInfoAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($detailInfoAvailable, true), gettype($detailInfoAvailable)), __LINE__);
        }
        $this->detailInfoAvailable = $detailInfoAvailable;
        return $this;
    }
    /**
     * Get detailInfoAvailableMessage value
     * @return string|null
     */
    public function getDetailInfoAvailableMessage()
    {
        return $this->detailInfoAvailableMessage;
    }
    /**
     * Set detailInfoAvailableMessage value
     * @param string $detailInfoAvailableMessage
     * @return \StructType\ContractSearchDetail
     */
    public function setDetailInfoAvailableMessage($detailInfoAvailableMessage = null)
    {
        // validation for constraint: string
        if (!is_null($detailInfoAvailableMessage) && !is_string($detailInfoAvailableMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detailInfoAvailableMessage, true), gettype($detailInfoAvailableMessage)), __LINE__);
        }
        $this->detailInfoAvailableMessage = $detailInfoAvailableMessage;
        return $this;
    }
    /**
     * Get claimCategory value
     * @return string[]|null
     */
    public function getClaimCategory()
    {
        return $this->claimCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setClaimCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClaimCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClaimCategoryForArrayConstraintsFromSetClaimCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contractSearchDetailClaimCategoryItem) {
            // validation for constraint: enumeration
            if (!\EnumType\ClaimCategory::valueIsValid($contractSearchDetailClaimCategoryItem)) {
                $invalidValues[] = is_object($contractSearchDetailClaimCategoryItem) ? get_class($contractSearchDetailClaimCategoryItem) : sprintf('%s(%s)', gettype($contractSearchDetailClaimCategoryItem), var_export($contractSearchDetailClaimCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ClaimCategory', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\ClaimCategory::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set claimCategory value
     * @uses \EnumType\ClaimCategory::valueIsValid()
     * @uses \EnumType\ClaimCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $claimCategory
     * @return \StructType\ContractSearchDetail
     */
    public function setClaimCategory(array $claimCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($claimCategoryArrayErrorMessage = self::validateClaimCategoryForArrayConstraintsFromSetClaimCategory($claimCategory))) {
            throw new \InvalidArgumentException($claimCategoryArrayErrorMessage, __LINE__);
        }
        $this->claimCategory = $claimCategory;
        return $this;
    }
    /**
     * Add item to claimCategory value
     * @uses \EnumType\ClaimCategory::valueIsValid()
     * @uses \EnumType\ClaimCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ContractSearchDetail
     */
    public function addToClaimCategory($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ClaimCategory::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ClaimCategory', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\ClaimCategory::getValidValues())), __LINE__);
        }
        $this->claimCategory[] = $item;
        return $this;
    }
    /**
     * Get arztAkut value
     * @return bool|null
     */
    public function getArztAkut()
    {
        return $this->arztAkut;
    }
    /**
     * Set arztAkut value
     * @param bool $arztAkut
     * @return \StructType\ContractSearchDetail
     */
    public function setArztAkut($arztAkut = false)
    {
        // validation for constraint: boolean
        if (!is_null($arztAkut) && !is_bool($arztAkut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($arztAkut, true), gettype($arztAkut)), __LINE__);
        }
        $this->arztAkut = $arztAkut;
        return $this;
    }
    /**
     * Get virtSprechArzt value
     * @return bool|null
     */
    public function getVirtSprechArzt()
    {
        return $this->virtSprechArzt;
    }
    /**
     * Set virtSprechArzt value
     * @param bool $virtSprechArzt
     * @return \StructType\ContractSearchDetail
     */
    public function setVirtSprechArzt($virtSprechArzt = false)
    {
        // validation for constraint: boolean
        if (!is_null($virtSprechArzt) && !is_bool($virtSprechArzt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($virtSprechArzt, true), gettype($virtSprechArzt)), __LINE__);
        }
        $this->virtSprechArzt = $virtSprechArzt;
        return $this;
    }
    /**
     * Get virtSprechCoach value
     * @return bool|null
     */
    public function getVirtSprechCoach()
    {
        return $this->virtSprechCoach;
    }
    /**
     * Set virtSprechCoach value
     * @param bool $virtSprechCoach
     * @return \StructType\ContractSearchDetail
     */
    public function setVirtSprechCoach($virtSprechCoach = false)
    {
        // validation for constraint: boolean
        if (!is_null($virtSprechCoach) && !is_bool($virtSprechCoach)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($virtSprechCoach, true), gettype($virtSprechCoach)), __LINE__);
        }
        $this->virtSprechCoach = $virtSprechCoach;
        return $this;
    }
    /**
     * Get suchenBuchen value
     * @return bool|null
     */
    public function getSuchenBuchen()
    {
        return $this->suchenBuchen;
    }
    /**
     * Set suchenBuchen value
     * @param bool $suchenBuchen
     * @return \StructType\ContractSearchDetail
     */
    public function setSuchenBuchen($suchenBuchen = false)
    {
        // validation for constraint: boolean
        if (!is_null($suchenBuchen) && !is_bool($suchenBuchen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($suchenBuchen, true), gettype($suchenBuchen)), __LINE__);
        }
        $this->suchenBuchen = $suchenBuchen;
        return $this;
    }
    /**
     * Get gesundCoach value
     * @return bool|null
     */
    public function getGesundCoach()
    {
        return $this->gesundCoach;
    }
    /**
     * Set gesundCoach value
     * @param bool $gesundCoach
     * @return \StructType\ContractSearchDetail
     */
    public function setGesundCoach($gesundCoach = false)
    {
        // validation for constraint: boolean
        if (!is_null($gesundCoach) && !is_bool($gesundCoach)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($gesundCoach, true), gettype($gesundCoach)), __LINE__);
        }
        $this->gesundCoach = $gesundCoach;
        return $this;
    }
    /**
     * Get hasRundumGesund value
     * @return bool|null
     */
    public function getHasRundumGesund()
    {
        return $this->hasRundumGesund;
    }
    /**
     * Set hasRundumGesund value
     * @param bool $hasRundumGesund
     * @return \StructType\ContractSearchDetail
     */
    public function setHasRundumGesund($hasRundumGesund = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasRundumGesund) && !is_bool($hasRundumGesund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasRundumGesund, true), gettype($hasRundumGesund)), __LINE__);
        }
        $this->hasRundumGesund = $hasRundumGesund;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContractSearchDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
