<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContractSearch StructType
 * Meta information extracted from the WSDL
 * - documentation: Vertragssuche
 * @subpackage Structs
 */
class ContractSearch extends AbstractStructBase
{
    /**
     * The sureName
     * Meta information extracted from the WSDL
     * - documentation: Familien-, Gruppen-, bzw. Firmenname
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $sureName;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - documentation: Vorname für natürliche Personen
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The zipCode
     * Meta information extracted from the WSDL
     * - documentation: Postleitzahl
     * - minOccurs: 0
     * @var int
     */
    public $zipCode;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - documentation: Ort
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The agentNumber
     * Meta information extracted from the WSDL
     * - documentation: Vermittlernummer z.B: 123456
     * - base: xsd:string
     * - maxLength: 6
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $agentNumber;
    /**
     * The onlyActive
     * Meta information extracted from the WSDL
     * - documentation: nur aktive schäden, default yes
     * - minOccurs: 0
     * @var bool
     */
    public $onlyActive;
    /**
     * The policyType
     * Meta information extracted from the WSDL
     * - documentation: nur einen spezielle typ suchen
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $policyType;
    /**
     * Constructor method for ContractSearch
     * @uses ContractSearch::setSureName()
     * @uses ContractSearch::setFirstName()
     * @uses ContractSearch::setZipCode()
     * @uses ContractSearch::setCity()
     * @uses ContractSearch::setAgentNumber()
     * @uses ContractSearch::setOnlyActive()
     * @uses ContractSearch::setPolicyType()
     * @param string $sureName
     * @param string $firstName
     * @param int $zipCode
     * @param string $city
     * @param string[] $agentNumber
     * @param bool $onlyActive
     * @param string[] $policyType
     */
    public function __construct($sureName = null, $firstName = null, $zipCode = null, $city = null, array $agentNumber = array(), $onlyActive = null, array $policyType = array())
    {
        $this
            ->setSureName($sureName)
            ->setFirstName($firstName)
            ->setZipCode($zipCode)
            ->setCity($city)
            ->setAgentNumber($agentNumber)
            ->setOnlyActive($onlyActive)
            ->setPolicyType($policyType);
    }
    /**
     * Get sureName value
     * @return string|null
     */
    public function getSureName()
    {
        return $this->sureName;
    }
    /**
     * Set sureName value
     * @param string $sureName
     * @return \StructType\ContractSearch
     */
    public function setSureName($sureName = null)
    {
        // validation for constraint: string
        if (!is_null($sureName) && !is_string($sureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sureName, true), gettype($sureName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($sureName) && mb_strlen($sureName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($sureName)), __LINE__);
        }
        $this->sureName = $sureName;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\ContractSearch
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($firstName) && mb_strlen($firstName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get zipCode value
     * @return int|null
     */
    public function getZipCode()
    {
        return $this->zipCode;
    }
    /**
     * Set zipCode value
     * @param int $zipCode
     * @return \StructType\ContractSearch
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: int
        if (!is_null($zipCode) && !(is_int($zipCode) || ctype_digit($zipCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->zipCode = $zipCode;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\ContractSearch
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get agentNumber value
     * @return string[]|null
     */
    public function getAgentNumber()
    {
        return $this->agentNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setAgentNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAgentNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAgentNumberForArrayConstraintsFromSetAgentNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contractSearchAgentNumberItem) {
            // validation for constraint: itemType
            if (!is_string($contractSearchAgentNumberItem)) {
                $invalidValues[] = is_object($contractSearchAgentNumberItem) ? get_class($contractSearchAgentNumberItem) : sprintf('%s(%s)', gettype($contractSearchAgentNumberItem), var_export($contractSearchAgentNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The agentNumber property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setAgentNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAgentNumber method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAgentNumberForMaxLengthConstraintFromSetAgentNumber($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contractSearchAgentNumberItem) {
            // validation for constraint: maxLength(6)
            if (mb_strlen($contractSearchAgentNumberItem) > 6) {
                $invalidValues[] = var_export($contractSearchAgentNumberItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 6', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set agentNumber value
     * @throws \InvalidArgumentException
     * @param string[] $agentNumber
     * @return \StructType\ContractSearch
     */
    public function setAgentNumber(array $agentNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($agentNumberArrayErrorMessage = self::validateAgentNumberForArrayConstraintsFromSetAgentNumber($agentNumber))) {
            throw new \InvalidArgumentException($agentNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(6)
        if ('' !== ($agentNumberMaxLengthErrorMessage = self::validateAgentNumberForMaxLengthConstraintFromSetAgentNumber($agentNumber))) {
            throw new \InvalidArgumentException($agentNumberMaxLengthErrorMessage, __LINE__);
        }
        $this->agentNumber = $agentNumber;
        return $this;
    }
    /**
     * Add item to agentNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ContractSearch
     */
    public function addToAgentNumber($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The agentNumber property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (mb_strlen($item) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($item)), __LINE__);
        }
        $this->agentNumber[] = $item;
        return $this;
    }
    /**
     * Get onlyActive value
     * @return bool|null
     */
    public function getOnlyActive()
    {
        return $this->onlyActive;
    }
    /**
     * Set onlyActive value
     * @param bool $onlyActive
     * @return \StructType\ContractSearch
     */
    public function setOnlyActive($onlyActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyActive) && !is_bool($onlyActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlyActive, true), gettype($onlyActive)), __LINE__);
        }
        $this->onlyActive = $onlyActive;
        return $this;
    }
    /**
     * Get policyType value
     * @return string[]|null
     */
    public function getPolicyType()
    {
        return $this->policyType;
    }
    /**
     * This method is responsible for validating the values passed to the setPolicyType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicyType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePolicyTypeForArrayConstraintsFromSetPolicyType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contractSearchPolicyTypeItem) {
            // validation for constraint: enumeration
            if (!\EnumType\PolicyType::valueIsValid($contractSearchPolicyTypeItem)) {
                $invalidValues[] = is_object($contractSearchPolicyTypeItem) ? get_class($contractSearchPolicyTypeItem) : sprintf('%s(%s)', gettype($contractSearchPolicyTypeItem), var_export($contractSearchPolicyTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PolicyType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\PolicyType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set policyType value
     * @uses \EnumType\PolicyType::valueIsValid()
     * @uses \EnumType\PolicyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $policyType
     * @return \StructType\ContractSearch
     */
    public function setPolicyType(array $policyType = array())
    {
        // validation for constraint: array
        if ('' !== ($policyTypeArrayErrorMessage = self::validatePolicyTypeForArrayConstraintsFromSetPolicyType($policyType))) {
            throw new \InvalidArgumentException($policyTypeArrayErrorMessage, __LINE__);
        }
        $this->policyType = $policyType;
        return $this;
    }
    /**
     * Add item to policyType value
     * @uses \EnumType\PolicyType::valueIsValid()
     * @uses \EnumType\PolicyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ContractSearch
     */
    public function addToPolicyType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PolicyType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PolicyType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\PolicyType::getValidValues())), __LINE__);
        }
        $this->policyType[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContractSearch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
