<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Consultation_SMOnline StructType
 * Meta information extracted from the WSDL
 * - documentation: Detaildatenobjekt einer Schadenmeldung
 * @subpackage Structs
 */
class Consultation_SMOnline extends AbstractStructBase
{
    /**
     * The policyNumber
     * Meta information extracted from the WSDL
     * - documentation: Polizzennummer eines Vorvertrages
     * - minOccurs: 0
     * @var string
     */
    public $policyNumber;
    /**
     * The externalClaimNumber
     * Meta information extracted from the WSDL
     * - documentation: Schadensnummer des externen Systems (max. 30 Stellen)
     * - minOccurs: 0
     * @var string
     */
    public $externalClaimNumber;
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - documentation: Kontaktdaten Objekt
     * - minOccurs: 0
     * @var \StructType\Contact
     */
    public $contact;
    /**
     * The attachment
     * Meta information extracted from the WSDL
     * - documentation: Attachment Objekte
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Attachment[]
     */
    public $attachment;
    /**
     * The bankAccount
     * Meta information extracted from the WSDL
     * - documentation: Bankdaten
     * - minOccurs: 0
     * @var \StructType\BankAccount
     */
    public $bankAccount;
    /**
     * The attestor
     * Meta information extracted from the WSDL
     * - documentation: Zeugen
     * - base: xsd:string
     * - maxLength: 80
     * - minOccurs: 0
     * @var string
     */
    public $attestor;
    /**
     * The claiment
     * Meta information extracted from the WSDL
     * - documentation: Geschädigter alt(zwecks Abwärtskompatibilität weiterhin möglich, Feld wird allerdings nicht gemapped)
     * - choice: claiment | claimentFields
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $claiment;
    /**
     * The claimentFields
     * Meta information extracted from the WSDL
     * - choice: claiment | claimentFields
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Claiment
     */
    public $claimentFields;
    /**
     * The car
     * Meta information extracted from the WSDL
     * - documentation: Fahrzeug des Geschädigten (z.B. Kennzeichen, Type, Art der Beschädigung, Kfz-Vers.)
     * - minOccurs: 0
     * @var string
     */
    public $car;
    /**
     * The additionalInformation
     * Meta information extracted from the WSDL
     * - documentation: Zusätzliche Informationen
     * - minOccurs: 0
     * @var string
     */
    public $additionalInformation;
    /**
     * The eventDate
     * Meta information extracted from the WSDL
     * - documentation: Ergeignisdatum
     * - minOccurs: 0
     * @var string
     */
    public $eventDate;
    /**
     * The eventTime
     * Meta information extracted from the WSDL
     * - documentation: Ereignis-Uhrzeit
     * - minOccurs: 0
     * @var string
     */
    public $eventTime;
    /**
     * The eventPlace
     * Meta information extracted from the WSDL
     * - documentation: Schadenort
     * - base: xsd:string
     * - maxLength: 100
     * - minOccurs: 0
     * @var string
     */
    public $eventPlace;
    /**
     * The courseOfEvent
     * Meta information extracted from the WSDL
     * - documentation: Schadenhergang
     * - minOccurs: 0
     * @var string
     */
    public $courseOfEvent;
    /**
     * The officialRecord
     * Meta information extracted from the WSDL
     * - documentation: Behördliche Aufnahme
     * - minOccurs: 0
     * @var bool
     */
    public $officialRecord;
    /**
     * The carLicenceNumber
     * Meta information extracted from the WSDL
     * - documentation: KFZ-Kennzeichen
     * - minOccurs: 0
     * @var string
     */
    public $carLicenceNumber;
    /**
     * The claimFor
     * Meta information extracted from the WSDL
     * - documentation: Schadenmeldung zu
     * - minOccurs: 0
     * @var string
     */
    public $claimFor;
    /**
     * The claimCategory
     * Meta information extracted from the WSDL
     * - documentation: Schadensparte
     * - minOccurs: 0
     * @var string
     */
    public $claimCategory;
    /**
     * The causeOfClaim
     * Meta information extracted from the WSDL
     * - documentation: Schadenursache
     * - minOccurs: 0
     * @var string
     */
    public $causeOfClaim;
    /**
     * The estimatedDamageAmount
     * Meta information extracted from the WSDL
     * - documentation: voraussichtliche Schadenhöhe
     * - minOccurs: 0
     * @var float
     */
    public $estimatedDamageAmount;
    /**
     * The validDriveringLicence
     * Meta information extracted from the WSDL
     * - documentation: Gültiger Führerschein
     * - minOccurs: 0
     * @var string
     */
    public $validDriveringLicence;
    /**
     * The fuehrerscheinAusstellungsdatumGruppe
     * Meta information extracted from the WSDL
     * - documentation: Ausstellungsdatum des Führerscheins, Gruppe, etc
     * - minOccurs: 0
     * @var string
     */
    public $fuehrerscheinAusstellungsdatumGruppe;
    /**
     * The verletzungsArt
     * Meta information extracted from the WSDL
     * - documentation: Verletzungsart
     * - minOccurs: 0
     * @var string
     */
    public $verletzungsArt;
    /**
     * The unfallart
     * Meta information extracted from the WSDL
     * - documentation: Unfallart
     * - base: xsd:integer
     * - minOccurs: 0
     * - totalDigits: 2
     * @var int
     */
    public $unfallart;
    /**
     * The verletzterKoerperteil
     * Meta information extracted from the WSDL
     * - documentation: Verletzter Körperteil
     * - base: xsd:integer
     * - minOccurs: 0
     * - totalDigits: 2
     * @var int
     */
    public $verletzterKoerperteil;
    /**
     * The verletzteKoerperseite
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $verletzteKoerperseite;
    /**
     * The nameVerletztePerson
     * Meta information extracted from the WSDL
     * - documentation: Name der verletzten Person
     * - minOccurs: 0
     * @var string
     */
    public $nameVerletztePerson;
    /**
     * The berufVerletztePerson
     * Meta information extracted from the WSDL
     * - documentation: Beruf der verletzten Person
     * - minOccurs: 0
     * @var int
     */
    public $berufVerletztePerson;
    /**
     * The gebdatVerletztePerson
     * Meta information extracted from the WSDL
     * - documentation: Geburtsdatum der verletzten Person
     * - minOccurs: 0
     * @var string
     */
    public $gebdatVerletztePerson;
    /**
     * The arbeitsunfaehigVon
     * Meta information extracted from the WSDL
     * - documentation: Arbeitsunfähigkeit von
     * - minOccurs: 0
     * @var string
     */
    public $arbeitsunfaehigVon;
    /**
     * The arbeitsunfaehigBis
     * Meta information extracted from the WSDL
     * - documentation: Arbeitsunfährigkeit bis
     * - minOccurs: 0
     * @var string
     */
    public $arbeitsunfaehigBis;
    /**
     * The diagnose
     * Meta information extracted from the WSDL
     * - documentation: Diagnose
     * - minOccurs: 0
     * @var string
     */
    public $diagnose;
    /**
     * The nebenVersicherung
     * Meta information extracted from the WSDL
     * - documentation: Nebenversicherung
     * - minOccurs: 0
     * @var string
     */
    public $nebenVersicherung;
    /**
     * The officialRecordText
     * Meta information extracted from the WSDL
     * - documentation: Behördliche Aufname Dienstelle etc
     * - minOccurs: 0
     * @var string
     */
    public $officialRecordText;
    /**
     * The datenUnfallgegner
     * Meta information extracted from the WSDL
     * - documentation: Daten des Unfallgegners
     * - minOccurs: 0
     * @var string
     */
    public $datenUnfallgegner;
    /**
     * The beschaedigteSachen
     * Meta information extracted from the WSDL
     * - documentation: beschädigte Sachen
     * - minOccurs: 0
     * @var string
     */
    public $beschaedigteSachen;
    /**
     * The verletzungsart
     * Meta information extracted from the WSDL
     * - documentation: Verletzungsart
     * - minOccurs: 0
     * @var string
     */
    public $verletzungsart;
    /**
     * The besichtigungErwuenscht
     * Meta information extracted from the WSDL
     * - documentation: Besichtigung Erwünscht
     * - minOccurs: 0
     * @var bool
     */
    public $besichtigungErwuenscht;
    /**
     * The abloeseErwuenscht
     * Meta information extracted from the WSDL
     * - documentation: Ablöse Erwünscht
     * - minOccurs: 0
     * @var bool
     */
    public $abloeseErwuenscht;
    /**
     * The schadenland
     * Meta information extracted from the WSDL
     * - documentation: Code des Schadenlandes
     * - base: xsd:string
     * - maxLength: 3
     * - minOccurs: 0
     * @var string
     */
    public $schadenland;
    /**
     * The vpName
     * Meta information extracted from the WSDL
     * - documentation: Name der versichererten Person
     * - minOccurs: 0
     * @var string
     */
    public $vpName;
    /**
     * The vpGebdat
     * Meta information extracted from the WSDL
     * - documentation: Geburtsdatum der versichererten Person
     * - minOccurs: 0
     * @var string
     */
    public $vpGebdat;
    /**
     * The behandlerName
     * Meta information extracted from the WSDL
     * - documentation: Behandlername
     * - minOccurs: 0
     * @var string
     */
    public $behandlerName;
    /**
     * Constructor method for Consultation_SMOnline
     * @uses Consultation_SMOnline::setPolicyNumber()
     * @uses Consultation_SMOnline::setExternalClaimNumber()
     * @uses Consultation_SMOnline::setContact()
     * @uses Consultation_SMOnline::setAttachment()
     * @uses Consultation_SMOnline::setBankAccount()
     * @uses Consultation_SMOnline::setAttestor()
     * @uses Consultation_SMOnline::setClaiment()
     * @uses Consultation_SMOnline::setClaimentFields()
     * @uses Consultation_SMOnline::setCar()
     * @uses Consultation_SMOnline::setAdditionalInformation()
     * @uses Consultation_SMOnline::setEventDate()
     * @uses Consultation_SMOnline::setEventTime()
     * @uses Consultation_SMOnline::setEventPlace()
     * @uses Consultation_SMOnline::setCourseOfEvent()
     * @uses Consultation_SMOnline::setOfficialRecord()
     * @uses Consultation_SMOnline::setCarLicenceNumber()
     * @uses Consultation_SMOnline::setClaimFor()
     * @uses Consultation_SMOnline::setClaimCategory()
     * @uses Consultation_SMOnline::setCauseOfClaim()
     * @uses Consultation_SMOnline::setEstimatedDamageAmount()
     * @uses Consultation_SMOnline::setValidDriveringLicence()
     * @uses Consultation_SMOnline::setFuehrerscheinAusstellungsdatumGruppe()
     * @uses Consultation_SMOnline::setVerletzungsArt()
     * @uses Consultation_SMOnline::setUnfallart()
     * @uses Consultation_SMOnline::setVerletzterKoerperteil()
     * @uses Consultation_SMOnline::setVerletzteKoerperseite()
     * @uses Consultation_SMOnline::setNameVerletztePerson()
     * @uses Consultation_SMOnline::setBerufVerletztePerson()
     * @uses Consultation_SMOnline::setGebdatVerletztePerson()
     * @uses Consultation_SMOnline::setArbeitsunfaehigVon()
     * @uses Consultation_SMOnline::setArbeitsunfaehigBis()
     * @uses Consultation_SMOnline::setDiagnose()
     * @uses Consultation_SMOnline::setNebenVersicherung()
     * @uses Consultation_SMOnline::setOfficialRecordText()
     * @uses Consultation_SMOnline::setDatenUnfallgegner()
     * @uses Consultation_SMOnline::setBeschaedigteSachen()
     * @uses Consultation_SMOnline::setVerletzungsart_1()
     * @uses Consultation_SMOnline::setBesichtigungErwuenscht()
     * @uses Consultation_SMOnline::setAbloeseErwuenscht()
     * @uses Consultation_SMOnline::setSchadenland()
     * @uses Consultation_SMOnline::setVpName()
     * @uses Consultation_SMOnline::setVpGebdat()
     * @uses Consultation_SMOnline::setBehandlerName()
     * @param string $policyNumber
     * @param string $externalClaimNumber
     * @param \StructType\Contact $contact
     * @param \StructType\Attachment[] $attachment
     * @param \StructType\BankAccount $bankAccount
     * @param string $attestor
     * @param string $claiment
     * @param \StructType\Claiment $claimentFields
     * @param string $car
     * @param string $additionalInformation
     * @param string $eventDate
     * @param string $eventTime
     * @param string $eventPlace
     * @param string $courseOfEvent
     * @param bool $officialRecord
     * @param string $carLicenceNumber
     * @param string $claimFor
     * @param string $claimCategory
     * @param string $causeOfClaim
     * @param float $estimatedDamageAmount
     * @param string $validDriveringLicence
     * @param string $fuehrerscheinAusstellungsdatumGruppe
     * @param string $verletzungsArt
     * @param int $unfallart
     * @param int $verletzterKoerperteil
     * @param string $verletzteKoerperseite
     * @param string $nameVerletztePerson
     * @param int $berufVerletztePerson
     * @param string $gebdatVerletztePerson
     * @param string $arbeitsunfaehigVon
     * @param string $arbeitsunfaehigBis
     * @param string $diagnose
     * @param string $nebenVersicherung
     * @param string $officialRecordText
     * @param string $datenUnfallgegner
     * @param string $beschaedigteSachen
     * @param string $verletzungsart
     * @param bool $besichtigungErwuenscht
     * @param bool $abloeseErwuenscht
     * @param string $schadenland
     * @param string $vpName
     * @param string $vpGebdat
     * @param string $behandlerName
     */
    public function __construct($policyNumber = null, $externalClaimNumber = null, \StructType\Contact $contact = null, array $attachment = array(), \StructType\BankAccount $bankAccount = null, $attestor = null, $claiment = null, \StructType\Claiment $claimentFields = null, $car = null, $additionalInformation = null, $eventDate = null, $eventTime = null, $eventPlace = null, $courseOfEvent = null, $officialRecord = null, $carLicenceNumber = null, $claimFor = null, $claimCategory = null, $causeOfClaim = null, $estimatedDamageAmount = null, $validDriveringLicence = null, $fuehrerscheinAusstellungsdatumGruppe = null, $verletzungsArt = null, $unfallart = null, $verletzterKoerperteil = null, $verletzteKoerperseite = null, $nameVerletztePerson = null, $berufVerletztePerson = null, $gebdatVerletztePerson = null, $arbeitsunfaehigVon = null, $arbeitsunfaehigBis = null, $diagnose = null, $nebenVersicherung = null, $officialRecordText = null, $datenUnfallgegner = null, $beschaedigteSachen = null, $verletzungsart_1 = null, $besichtigungErwuenscht = null, $abloeseErwuenscht = null, $schadenland = null, $vpName = null, $vpGebdat = null, $behandlerName = null)
    {
        $this
            ->setPolicyNumber($policyNumber)
            ->setExternalClaimNumber($externalClaimNumber)
            ->setContact($contact)
            ->setAttachment($attachment)
            ->setBankAccount($bankAccount)
            ->setAttestor($attestor)
            ->setClaiment($claiment)
            ->setClaimentFields($claimentFields)
            ->setCar($car)
            ->setAdditionalInformation($additionalInformation)
            ->setEventDate($eventDate)
            ->setEventTime($eventTime)
            ->setEventPlace($eventPlace)
            ->setCourseOfEvent($courseOfEvent)
            ->setOfficialRecord($officialRecord)
            ->setCarLicenceNumber($carLicenceNumber)
            ->setClaimFor($claimFor)
            ->setClaimCategory($claimCategory)
            ->setCauseOfClaim($causeOfClaim)
            ->setEstimatedDamageAmount($estimatedDamageAmount)
            ->setValidDriveringLicence($validDriveringLicence)
            ->setFuehrerscheinAusstellungsdatumGruppe($fuehrerscheinAusstellungsdatumGruppe)
            ->setVerletzungsArt($verletzungsArt)
            ->setUnfallart($unfallart)
            ->setVerletzterKoerperteil($verletzterKoerperteil)
            ->setVerletzteKoerperseite($verletzteKoerperseite)
            ->setNameVerletztePerson($nameVerletztePerson)
            ->setBerufVerletztePerson($berufVerletztePerson)
            ->setGebdatVerletztePerson($gebdatVerletztePerson)
            ->setArbeitsunfaehigVon($arbeitsunfaehigVon)
            ->setArbeitsunfaehigBis($arbeitsunfaehigBis)
            ->setDiagnose($diagnose)
            ->setNebenVersicherung($nebenVersicherung)
            ->setOfficialRecordText($officialRecordText)
            ->setDatenUnfallgegner($datenUnfallgegner)
            ->setBeschaedigteSachen($beschaedigteSachen)
            ->setVerletzungsart_1($verletzungsart_1)
            ->setBesichtigungErwuenscht($besichtigungErwuenscht)
            ->setAbloeseErwuenscht($abloeseErwuenscht)
            ->setSchadenland($schadenland)
            ->setVpName($vpName)
            ->setVpGebdat($vpGebdat)
            ->setBehandlerName($behandlerName);
    }
    /**
     * Get policyNumber value
     * @return string|null
     */
    public function getPolicyNumber()
    {
        return $this->policyNumber;
    }
    /**
     * Set policyNumber value
     * @param string $policyNumber
     * @return \StructType\Consultation_SMOnline
     */
    public function setPolicyNumber($policyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($policyNumber) && !is_string($policyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyNumber, true), gettype($policyNumber)), __LINE__);
        }
        $this->policyNumber = $policyNumber;
        return $this;
    }
    /**
     * Get externalClaimNumber value
     * @return string|null
     */
    public function getExternalClaimNumber()
    {
        return $this->externalClaimNumber;
    }
    /**
     * Set externalClaimNumber value
     * @param string $externalClaimNumber
     * @return \StructType\Consultation_SMOnline
     */
    public function setExternalClaimNumber($externalClaimNumber = null)
    {
        // validation for constraint: string
        if (!is_null($externalClaimNumber) && !is_string($externalClaimNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalClaimNumber, true), gettype($externalClaimNumber)), __LINE__);
        }
        $this->externalClaimNumber = $externalClaimNumber;
        return $this;
    }
    /**
     * Get contact value
     * @return \StructType\Contact|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param \StructType\Contact $contact
     * @return \StructType\Consultation_SMOnline
     */
    public function setContact(\StructType\Contact $contact = null)
    {
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get attachment value
     * @return \StructType\Attachment[]|null
     */
    public function getAttachment()
    {
        return $this->attachment;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachmentForArrayConstraintsFromSetAttachment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consultation_SMOnlineAttachmentItem) {
            // validation for constraint: itemType
            if (!$consultation_SMOnlineAttachmentItem instanceof \StructType\Attachment) {
                $invalidValues[] = is_object($consultation_SMOnlineAttachmentItem) ? get_class($consultation_SMOnlineAttachmentItem) : sprintf('%s(%s)', gettype($consultation_SMOnlineAttachmentItem), var_export($consultation_SMOnlineAttachmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The attachment property can only contain items of type \StructType\Attachment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment[] $attachment
     * @return \StructType\Consultation_SMOnline
     */
    public function setAttachment(array $attachment = array())
    {
        // validation for constraint: array
        if ('' !== ($attachmentArrayErrorMessage = self::validateAttachmentForArrayConstraintsFromSetAttachment($attachment))) {
            throw new \InvalidArgumentException($attachmentArrayErrorMessage, __LINE__);
        }
        $this->attachment = $attachment;
        return $this;
    }
    /**
     * Add item to attachment value
     * @throws \InvalidArgumentException
     * @param \StructType\Attachment $item
     * @return \StructType\Consultation_SMOnline
     */
    public function addToAttachment(\StructType\Attachment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attachment) {
            throw new \InvalidArgumentException(sprintf('The attachment property can only contain items of type \StructType\Attachment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->attachment[] = $item;
        return $this;
    }
    /**
     * Get bankAccount value
     * @return \StructType\BankAccount|null
     */
    public function getBankAccount()
    {
        return $this->bankAccount;
    }
    /**
     * Set bankAccount value
     * @param \StructType\BankAccount $bankAccount
     * @return \StructType\Consultation_SMOnline
     */
    public function setBankAccount(\StructType\BankAccount $bankAccount = null)
    {
        $this->bankAccount = $bankAccount;
        return $this;
    }
    /**
     * Get attestor value
     * @return string|null
     */
    public function getAttestor()
    {
        return $this->attestor;
    }
    /**
     * Set attestor value
     * @param string $attestor
     * @return \StructType\Consultation_SMOnline
     */
    public function setAttestor($attestor = null)
    {
        // validation for constraint: string
        if (!is_null($attestor) && !is_string($attestor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attestor, true), gettype($attestor)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($attestor) && mb_strlen($attestor) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($attestor)), __LINE__);
        }
        $this->attestor = $attestor;
        return $this;
    }
    /**
     * Get claiment value
     * @return string|null
     */
    public function getClaiment()
    {
        return isset($this->claiment) ? $this->claiment : null;
    }
    /**
     * This method is responsible for validating the value passed to the setClaiment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClaiment method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateClaimentForChoiceConstraintsFromSetClaiment($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'claimentFields',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property claiment can\'t be set as the property %s is already set. Only one property must be set among these properties: claiment, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set claiment value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $claiment
     * @return \StructType\Consultation_SMOnline
     */
    public function setClaiment($claiment = null)
    {
        // validation for constraint: string
        if (!is_null($claiment) && !is_string($claiment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claiment, true), gettype($claiment)), __LINE__);
        }
        // validation for constraint: choice(claiment, claimentFields)
        if ('' !== ($claimentChoiceErrorMessage = self::validateClaimentForChoiceConstraintsFromSetClaiment($claiment))) {
            throw new \InvalidArgumentException($claimentChoiceErrorMessage, __LINE__);
        }
        if (is_null($claiment) || (is_array($claiment) && empty($claiment))) {
            unset($this->claiment);
        } else {
            $this->claiment = $claiment;
        }
        return $this;
    }
    /**
     * Get claimentFields value
     * @return \StructType\Claiment|null
     */
    public function getClaimentFields()
    {
        return isset($this->claimentFields) ? $this->claimentFields : null;
    }
    /**
     * This method is responsible for validating the value passed to the setClaimentFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClaimentFields method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateClaimentFieldsForChoiceConstraintsFromSetClaimentFields($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'claiment',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property claimentFields can\'t be set as the property %s is already set. Only one property must be set among these properties: claimentFields, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set claimentFields value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Claiment $claimentFields
     * @return \StructType\Consultation_SMOnline
     */
    public function setClaimentFields(\StructType\Claiment $claimentFields = null)
    {
        // validation for constraint: choice(claiment, claimentFields)
        if ('' !== ($claimentFieldsChoiceErrorMessage = self::validateClaimentFieldsForChoiceConstraintsFromSetClaimentFields($claimentFields))) {
            throw new \InvalidArgumentException($claimentFieldsChoiceErrorMessage, __LINE__);
        }
        if (is_null($claimentFields) || (is_array($claimentFields) && empty($claimentFields))) {
            unset($this->claimentFields);
        } else {
            $this->claimentFields = $claimentFields;
        }
        return $this;
    }
    /**
     * Get car value
     * @return string|null
     */
    public function getCar()
    {
        return $this->car;
    }
    /**
     * Set car value
     * @param string $car
     * @return \StructType\Consultation_SMOnline
     */
    public function setCar($car = null)
    {
        // validation for constraint: string
        if (!is_null($car) && !is_string($car)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($car, true), gettype($car)), __LINE__);
        }
        $this->car = $car;
        return $this;
    }
    /**
     * Get additionalInformation value
     * @return string|null
     */
    public function getAdditionalInformation()
    {
        return $this->additionalInformation;
    }
    /**
     * Set additionalInformation value
     * @param string $additionalInformation
     * @return \StructType\Consultation_SMOnline
     */
    public function setAdditionalInformation($additionalInformation = null)
    {
        // validation for constraint: string
        if (!is_null($additionalInformation) && !is_string($additionalInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalInformation, true), gettype($additionalInformation)), __LINE__);
        }
        $this->additionalInformation = $additionalInformation;
        return $this;
    }
    /**
     * Get eventDate value
     * @return string|null
     */
    public function getEventDate()
    {
        return $this->eventDate;
    }
    /**
     * Set eventDate value
     * @param string $eventDate
     * @return \StructType\Consultation_SMOnline
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        $this->eventDate = $eventDate;
        return $this;
    }
    /**
     * Get eventTime value
     * @return string|null
     */
    public function getEventTime()
    {
        return $this->eventTime;
    }
    /**
     * Set eventTime value
     * @param string $eventTime
     * @return \StructType\Consultation_SMOnline
     */
    public function setEventTime($eventTime = null)
    {
        // validation for constraint: string
        if (!is_null($eventTime) && !is_string($eventTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTime, true), gettype($eventTime)), __LINE__);
        }
        $this->eventTime = $eventTime;
        return $this;
    }
    /**
     * Get eventPlace value
     * @return string|null
     */
    public function getEventPlace()
    {
        return $this->eventPlace;
    }
    /**
     * Set eventPlace value
     * @param string $eventPlace
     * @return \StructType\Consultation_SMOnline
     */
    public function setEventPlace($eventPlace = null)
    {
        // validation for constraint: string
        if (!is_null($eventPlace) && !is_string($eventPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventPlace, true), gettype($eventPlace)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($eventPlace) && mb_strlen($eventPlace) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($eventPlace)), __LINE__);
        }
        $this->eventPlace = $eventPlace;
        return $this;
    }
    /**
     * Get courseOfEvent value
     * @return string|null
     */
    public function getCourseOfEvent()
    {
        return $this->courseOfEvent;
    }
    /**
     * Set courseOfEvent value
     * @param string $courseOfEvent
     * @return \StructType\Consultation_SMOnline
     */
    public function setCourseOfEvent($courseOfEvent = null)
    {
        // validation for constraint: string
        if (!is_null($courseOfEvent) && !is_string($courseOfEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($courseOfEvent, true), gettype($courseOfEvent)), __LINE__);
        }
        $this->courseOfEvent = $courseOfEvent;
        return $this;
    }
    /**
     * Get officialRecord value
     * @return bool|null
     */
    public function getOfficialRecord()
    {
        return $this->officialRecord;
    }
    /**
     * Set officialRecord value
     * @param bool $officialRecord
     * @return \StructType\Consultation_SMOnline
     */
    public function setOfficialRecord($officialRecord = null)
    {
        // validation for constraint: boolean
        if (!is_null($officialRecord) && !is_bool($officialRecord)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($officialRecord, true), gettype($officialRecord)), __LINE__);
        }
        $this->officialRecord = $officialRecord;
        return $this;
    }
    /**
     * Get carLicenceNumber value
     * @return string|null
     */
    public function getCarLicenceNumber()
    {
        return $this->carLicenceNumber;
    }
    /**
     * Set carLicenceNumber value
     * @param string $carLicenceNumber
     * @return \StructType\Consultation_SMOnline
     */
    public function setCarLicenceNumber($carLicenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($carLicenceNumber) && !is_string($carLicenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carLicenceNumber, true), gettype($carLicenceNumber)), __LINE__);
        }
        $this->carLicenceNumber = $carLicenceNumber;
        return $this;
    }
    /**
     * Get claimFor value
     * @return string|null
     */
    public function getClaimFor()
    {
        return $this->claimFor;
    }
    /**
     * Set claimFor value
     * @param string $claimFor
     * @return \StructType\Consultation_SMOnline
     */
    public function setClaimFor($claimFor = null)
    {
        // validation for constraint: string
        if (!is_null($claimFor) && !is_string($claimFor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claimFor, true), gettype($claimFor)), __LINE__);
        }
        $this->claimFor = $claimFor;
        return $this;
    }
    /**
     * Get claimCategory value
     * @return string|null
     */
    public function getClaimCategory()
    {
        return $this->claimCategory;
    }
    /**
     * Set claimCategory value
     * @param string $claimCategory
     * @return \StructType\Consultation_SMOnline
     */
    public function setClaimCategory($claimCategory = null)
    {
        // validation for constraint: string
        if (!is_null($claimCategory) && !is_string($claimCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claimCategory, true), gettype($claimCategory)), __LINE__);
        }
        $this->claimCategory = $claimCategory;
        return $this;
    }
    /**
     * Get causeOfClaim value
     * @return string|null
     */
    public function getCauseOfClaim()
    {
        return $this->causeOfClaim;
    }
    /**
     * Set causeOfClaim value
     * @param string $causeOfClaim
     * @return \StructType\Consultation_SMOnline
     */
    public function setCauseOfClaim($causeOfClaim = null)
    {
        // validation for constraint: string
        if (!is_null($causeOfClaim) && !is_string($causeOfClaim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($causeOfClaim, true), gettype($causeOfClaim)), __LINE__);
        }
        $this->causeOfClaim = $causeOfClaim;
        return $this;
    }
    /**
     * Get estimatedDamageAmount value
     * @return float|null
     */
    public function getEstimatedDamageAmount()
    {
        return $this->estimatedDamageAmount;
    }
    /**
     * Set estimatedDamageAmount value
     * @param float $estimatedDamageAmount
     * @return \StructType\Consultation_SMOnline
     */
    public function setEstimatedDamageAmount($estimatedDamageAmount = null)
    {
        // validation for constraint: float
        if (!is_null($estimatedDamageAmount) && !(is_float($estimatedDamageAmount) || is_numeric($estimatedDamageAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatedDamageAmount, true), gettype($estimatedDamageAmount)), __LINE__);
        }
        $this->estimatedDamageAmount = $estimatedDamageAmount;
        return $this;
    }
    /**
     * Get validDriveringLicence value
     * @return string|null
     */
    public function getValidDriveringLicence()
    {
        return $this->validDriveringLicence;
    }
    /**
     * Set validDriveringLicence value
     * @uses \EnumType\JaNeinUnbekannt::valueIsValid()
     * @uses \EnumType\JaNeinUnbekannt::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $validDriveringLicence
     * @return \StructType\Consultation_SMOnline
     */
    public function setValidDriveringLicence($validDriveringLicence = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinUnbekannt::valueIsValid($validDriveringLicence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinUnbekannt', is_array($validDriveringLicence) ? implode(', ', $validDriveringLicence) : var_export($validDriveringLicence, true), implode(', ', \EnumType\JaNeinUnbekannt::getValidValues())), __LINE__);
        }
        $this->validDriveringLicence = $validDriveringLicence;
        return $this;
    }
    /**
     * Get fuehrerscheinAusstellungsdatumGruppe value
     * @return string|null
     */
    public function getFuehrerscheinAusstellungsdatumGruppe()
    {
        return $this->fuehrerscheinAusstellungsdatumGruppe;
    }
    /**
     * Set fuehrerscheinAusstellungsdatumGruppe value
     * @param string $fuehrerscheinAusstellungsdatumGruppe
     * @return \StructType\Consultation_SMOnline
     */
    public function setFuehrerscheinAusstellungsdatumGruppe($fuehrerscheinAusstellungsdatumGruppe = null)
    {
        // validation for constraint: string
        if (!is_null($fuehrerscheinAusstellungsdatumGruppe) && !is_string($fuehrerscheinAusstellungsdatumGruppe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fuehrerscheinAusstellungsdatumGruppe, true), gettype($fuehrerscheinAusstellungsdatumGruppe)), __LINE__);
        }
        $this->fuehrerscheinAusstellungsdatumGruppe = $fuehrerscheinAusstellungsdatumGruppe;
        return $this;
    }
    /**
     * Get verletzungsArt value
     * @return string|null
     */
    public function getVerletzungsArt()
    {
        return $this->verletzungsArt;
    }
    /**
     * Set verletzungsArt value
     * @param string $verletzungsArt
     * @return \StructType\Consultation_SMOnline
     */
    public function setVerletzungsArt($verletzungsArt = null)
    {
        // validation for constraint: string
        if (!is_null($verletzungsArt) && !is_string($verletzungsArt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verletzungsArt, true), gettype($verletzungsArt)), __LINE__);
        }
        $this->verletzungsArt = $verletzungsArt;
        return $this;
    }
    /**
     * Get unfallart value
     * @return int|null
     */
    public function getUnfallart()
    {
        return $this->unfallart;
    }
    /**
     * Set unfallart value
     * @param int $unfallart
     * @return \StructType\Consultation_SMOnline
     */
    public function setUnfallart($unfallart = null)
    {
        // validation for constraint: int
        if (!is_null($unfallart) && !(is_int($unfallart) || ctype_digit($unfallart))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unfallart, true), gettype($unfallart)), __LINE__);
        }
        // validation for constraint: totalDigits(2)
        if (!is_null($unfallart) && mb_strlen(preg_replace('/(\D)/', '', $unfallart)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 2 digits, "%d" given', var_export($unfallart, true), mb_strlen(preg_replace('/(\D)/', '', $unfallart))), __LINE__);
        }
        $this->unfallart = $unfallart;
        return $this;
    }
    /**
     * Get verletzterKoerperteil value
     * @return int|null
     */
    public function getVerletzterKoerperteil()
    {
        return $this->verletzterKoerperteil;
    }
    /**
     * Set verletzterKoerperteil value
     * @param int $verletzterKoerperteil
     * @return \StructType\Consultation_SMOnline
     */
    public function setVerletzterKoerperteil($verletzterKoerperteil = null)
    {
        // validation for constraint: int
        if (!is_null($verletzterKoerperteil) && !(is_int($verletzterKoerperteil) || ctype_digit($verletzterKoerperteil))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($verletzterKoerperteil, true), gettype($verletzterKoerperteil)), __LINE__);
        }
        // validation for constraint: totalDigits(2)
        if (!is_null($verletzterKoerperteil) && mb_strlen(preg_replace('/(\D)/', '', $verletzterKoerperteil)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 2 digits, "%d" given', var_export($verletzterKoerperteil, true), mb_strlen(preg_replace('/(\D)/', '', $verletzterKoerperteil))), __LINE__);
        }
        $this->verletzterKoerperteil = $verletzterKoerperteil;
        return $this;
    }
    /**
     * Get verletzteKoerperseite value
     * @return string|null
     */
    public function getVerletzteKoerperseite()
    {
        return $this->verletzteKoerperseite;
    }
    /**
     * Set verletzteKoerperseite value
     * @uses \EnumType\VerletzteKoerperseite::valueIsValid()
     * @uses \EnumType\VerletzteKoerperseite::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $verletzteKoerperseite
     * @return \StructType\Consultation_SMOnline
     */
    public function setVerletzteKoerperseite($verletzteKoerperseite = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VerletzteKoerperseite::valueIsValid($verletzteKoerperseite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VerletzteKoerperseite', is_array($verletzteKoerperseite) ? implode(', ', $verletzteKoerperseite) : var_export($verletzteKoerperseite, true), implode(', ', \EnumType\VerletzteKoerperseite::getValidValues())), __LINE__);
        }
        $this->verletzteKoerperseite = $verletzteKoerperseite;
        return $this;
    }
    /**
     * Get nameVerletztePerson value
     * @return string|null
     */
    public function getNameVerletztePerson()
    {
        return $this->nameVerletztePerson;
    }
    /**
     * Set nameVerletztePerson value
     * @param string $nameVerletztePerson
     * @return \StructType\Consultation_SMOnline
     */
    public function setNameVerletztePerson($nameVerletztePerson = null)
    {
        // validation for constraint: string
        if (!is_null($nameVerletztePerson) && !is_string($nameVerletztePerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameVerletztePerson, true), gettype($nameVerletztePerson)), __LINE__);
        }
        $this->nameVerletztePerson = $nameVerletztePerson;
        return $this;
    }
    /**
     * Get berufVerletztePerson value
     * @return int|null
     */
    public function getBerufVerletztePerson()
    {
        return $this->berufVerletztePerson;
    }
    /**
     * Set berufVerletztePerson value
     * @param int $berufVerletztePerson
     * @return \StructType\Consultation_SMOnline
     */
    public function setBerufVerletztePerson($berufVerletztePerson = null)
    {
        // validation for constraint: int
        if (!is_null($berufVerletztePerson) && !(is_int($berufVerletztePerson) || ctype_digit($berufVerletztePerson))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($berufVerletztePerson, true), gettype($berufVerletztePerson)), __LINE__);
        }
        $this->berufVerletztePerson = $berufVerletztePerson;
        return $this;
    }
    /**
     * Get gebdatVerletztePerson value
     * @return string|null
     */
    public function getGebdatVerletztePerson()
    {
        return $this->gebdatVerletztePerson;
    }
    /**
     * Set gebdatVerletztePerson value
     * @param string $gebdatVerletztePerson
     * @return \StructType\Consultation_SMOnline
     */
    public function setGebdatVerletztePerson($gebdatVerletztePerson = null)
    {
        // validation for constraint: string
        if (!is_null($gebdatVerletztePerson) && !is_string($gebdatVerletztePerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gebdatVerletztePerson, true), gettype($gebdatVerletztePerson)), __LINE__);
        }
        $this->gebdatVerletztePerson = $gebdatVerletztePerson;
        return $this;
    }
    /**
     * Get arbeitsunfaehigVon value
     * @return string|null
     */
    public function getArbeitsunfaehigVon()
    {
        return $this->arbeitsunfaehigVon;
    }
    /**
     * Set arbeitsunfaehigVon value
     * @param string $arbeitsunfaehigVon
     * @return \StructType\Consultation_SMOnline
     */
    public function setArbeitsunfaehigVon($arbeitsunfaehigVon = null)
    {
        // validation for constraint: string
        if (!is_null($arbeitsunfaehigVon) && !is_string($arbeitsunfaehigVon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arbeitsunfaehigVon, true), gettype($arbeitsunfaehigVon)), __LINE__);
        }
        $this->arbeitsunfaehigVon = $arbeitsunfaehigVon;
        return $this;
    }
    /**
     * Get arbeitsunfaehigBis value
     * @return string|null
     */
    public function getArbeitsunfaehigBis()
    {
        return $this->arbeitsunfaehigBis;
    }
    /**
     * Set arbeitsunfaehigBis value
     * @param string $arbeitsunfaehigBis
     * @return \StructType\Consultation_SMOnline
     */
    public function setArbeitsunfaehigBis($arbeitsunfaehigBis = null)
    {
        // validation for constraint: string
        if (!is_null($arbeitsunfaehigBis) && !is_string($arbeitsunfaehigBis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arbeitsunfaehigBis, true), gettype($arbeitsunfaehigBis)), __LINE__);
        }
        $this->arbeitsunfaehigBis = $arbeitsunfaehigBis;
        return $this;
    }
    /**
     * Get diagnose value
     * @return string|null
     */
    public function getDiagnose()
    {
        return $this->diagnose;
    }
    /**
     * Set diagnose value
     * @param string $diagnose
     * @return \StructType\Consultation_SMOnline
     */
    public function setDiagnose($diagnose = null)
    {
        // validation for constraint: string
        if (!is_null($diagnose) && !is_string($diagnose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($diagnose, true), gettype($diagnose)), __LINE__);
        }
        $this->diagnose = $diagnose;
        return $this;
    }
    /**
     * Get nebenVersicherung value
     * @return string|null
     */
    public function getNebenVersicherung()
    {
        return $this->nebenVersicherung;
    }
    /**
     * Set nebenVersicherung value
     * @uses \EnumType\JaNeinUnbekannt::valueIsValid()
     * @uses \EnumType\JaNeinUnbekannt::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nebenVersicherung
     * @return \StructType\Consultation_SMOnline
     */
    public function setNebenVersicherung($nebenVersicherung = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JaNeinUnbekannt::valueIsValid($nebenVersicherung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JaNeinUnbekannt', is_array($nebenVersicherung) ? implode(', ', $nebenVersicherung) : var_export($nebenVersicherung, true), implode(', ', \EnumType\JaNeinUnbekannt::getValidValues())), __LINE__);
        }
        $this->nebenVersicherung = $nebenVersicherung;
        return $this;
    }
    /**
     * Get officialRecordText value
     * @return string|null
     */
    public function getOfficialRecordText()
    {
        return $this->officialRecordText;
    }
    /**
     * Set officialRecordText value
     * @param string $officialRecordText
     * @return \StructType\Consultation_SMOnline
     */
    public function setOfficialRecordText($officialRecordText = null)
    {
        // validation for constraint: string
        if (!is_null($officialRecordText) && !is_string($officialRecordText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($officialRecordText, true), gettype($officialRecordText)), __LINE__);
        }
        $this->officialRecordText = $officialRecordText;
        return $this;
    }
    /**
     * Get datenUnfallgegner value
     * @return string|null
     */
    public function getDatenUnfallgegner()
    {
        return $this->datenUnfallgegner;
    }
    /**
     * Set datenUnfallgegner value
     * @param string $datenUnfallgegner
     * @return \StructType\Consultation_SMOnline
     */
    public function setDatenUnfallgegner($datenUnfallgegner = null)
    {
        // validation for constraint: string
        if (!is_null($datenUnfallgegner) && !is_string($datenUnfallgegner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datenUnfallgegner, true), gettype($datenUnfallgegner)), __LINE__);
        }
        $this->datenUnfallgegner = $datenUnfallgegner;
        return $this;
    }
    /**
     * Get beschaedigteSachen value
     * @return string|null
     */
    public function getBeschaedigteSachen()
    {
        return $this->beschaedigteSachen;
    }
    /**
     * Set beschaedigteSachen value
     * @param string $beschaedigteSachen
     * @return \StructType\Consultation_SMOnline
     */
    public function setBeschaedigteSachen($beschaedigteSachen = null)
    {
        // validation for constraint: string
        if (!is_null($beschaedigteSachen) && !is_string($beschaedigteSachen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beschaedigteSachen, true), gettype($beschaedigteSachen)), __LINE__);
        }
        $this->beschaedigteSachen = $beschaedigteSachen;
        return $this;
    }
    /**
     * Get verletzungsart value
     * @return string|null
     */
    public function getVerletzungsart_1()
    {
        return $this->verletzungsart;
    }
    /**
     * Set verletzungsart value
     * @param string $verletzungsart
     * @return \StructType\Consultation_SMOnline
     */
    public function setVerletzungsart_1($verletzungsart_1 = null)
    {
        // validation for constraint: string
        if (!is_null($verletzungsart_1) && !is_string($verletzungsart_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verletzungsart_1, true), gettype($verletzungsart_1)), __LINE__);
        }
        $this->verletzungsart = $verletzungsart_1;
        return $this;
    }
    /**
     * Get besichtigungErwuenscht value
     * @return bool|null
     */
    public function getBesichtigungErwuenscht()
    {
        return $this->besichtigungErwuenscht;
    }
    /**
     * Set besichtigungErwuenscht value
     * @param bool $besichtigungErwuenscht
     * @return \StructType\Consultation_SMOnline
     */
    public function setBesichtigungErwuenscht($besichtigungErwuenscht = null)
    {
        // validation for constraint: boolean
        if (!is_null($besichtigungErwuenscht) && !is_bool($besichtigungErwuenscht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($besichtigungErwuenscht, true), gettype($besichtigungErwuenscht)), __LINE__);
        }
        $this->besichtigungErwuenscht = $besichtigungErwuenscht;
        return $this;
    }
    /**
     * Get abloeseErwuenscht value
     * @return bool|null
     */
    public function getAbloeseErwuenscht()
    {
        return $this->abloeseErwuenscht;
    }
    /**
     * Set abloeseErwuenscht value
     * @param bool $abloeseErwuenscht
     * @return \StructType\Consultation_SMOnline
     */
    public function setAbloeseErwuenscht($abloeseErwuenscht = null)
    {
        // validation for constraint: boolean
        if (!is_null($abloeseErwuenscht) && !is_bool($abloeseErwuenscht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($abloeseErwuenscht, true), gettype($abloeseErwuenscht)), __LINE__);
        }
        $this->abloeseErwuenscht = $abloeseErwuenscht;
        return $this;
    }
    /**
     * Get schadenland value
     * @return string|null
     */
    public function getSchadenland()
    {
        return $this->schadenland;
    }
    /**
     * Set schadenland value
     * @param string $schadenland
     * @return \StructType\Consultation_SMOnline
     */
    public function setSchadenland($schadenland = null)
    {
        // validation for constraint: string
        if (!is_null($schadenland) && !is_string($schadenland)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schadenland, true), gettype($schadenland)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($schadenland) && mb_strlen($schadenland) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($schadenland)), __LINE__);
        }
        $this->schadenland = $schadenland;
        return $this;
    }
    /**
     * Get vpName value
     * @return string|null
     */
    public function getVpName()
    {
        return $this->vpName;
    }
    /**
     * Set vpName value
     * @param string $vpName
     * @return \StructType\Consultation_SMOnline
     */
    public function setVpName($vpName = null)
    {
        // validation for constraint: string
        if (!is_null($vpName) && !is_string($vpName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vpName, true), gettype($vpName)), __LINE__);
        }
        $this->vpName = $vpName;
        return $this;
    }
    /**
     * Get vpGebdat value
     * @return string|null
     */
    public function getVpGebdat()
    {
        return $this->vpGebdat;
    }
    /**
     * Set vpGebdat value
     * @param string $vpGebdat
     * @return \StructType\Consultation_SMOnline
     */
    public function setVpGebdat($vpGebdat = null)
    {
        // validation for constraint: string
        if (!is_null($vpGebdat) && !is_string($vpGebdat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vpGebdat, true), gettype($vpGebdat)), __LINE__);
        }
        $this->vpGebdat = $vpGebdat;
        return $this;
    }
    /**
     * Get behandlerName value
     * @return string|null
     */
    public function getBehandlerName()
    {
        return $this->behandlerName;
    }
    /**
     * Set behandlerName value
     * @param string $behandlerName
     * @return \StructType\Consultation_SMOnline
     */
    public function setBehandlerName($behandlerName = null)
    {
        // validation for constraint: string
        if (!is_null($behandlerName) && !is_string($behandlerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($behandlerName, true), gettype($behandlerName)), __LINE__);
        }
        $this->behandlerName = $behandlerName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Consultation_SMOnline
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
