<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for consultationProtocoll StructType
 * @subpackage Structs
 */
class ConsultationProtocoll extends AbstractStructBase
{
    /**
     * The agentSalutation
     * @var string
     */
    public $agentSalutation;
    /**
     * The agentSurename
     * @var string
     */
    public $agentSurename;
    /**
     * The agentFirstname
     * @var string
     */
    public $agentFirstname;
    /**
     * The agentGisaNr
     * @var string
     */
    public $agentGisaNr;
    /**
     * The agentSalesKind
     * @var string
     */
    public $agentSalesKind;
    /**
     * The agentIsuranceCompany
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $agentIsuranceCompany;
    /**
     * The customerDemands
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerDemands;
    /**
     * The consultationDate
     * @var string
     */
    public $consultationDate;
    /**
     * The consultationDuration
     * @var int
     */
    public $consultationDuration;
    /**
     * Constructor method for consultationProtocoll
     * @uses ConsultationProtocoll::setAgentSalutation()
     * @uses ConsultationProtocoll::setAgentSurename()
     * @uses ConsultationProtocoll::setAgentFirstname()
     * @uses ConsultationProtocoll::setAgentGisaNr()
     * @uses ConsultationProtocoll::setAgentSalesKind()
     * @uses ConsultationProtocoll::setAgentIsuranceCompany()
     * @uses ConsultationProtocoll::setCustomerDemands()
     * @uses ConsultationProtocoll::setConsultationDate()
     * @uses ConsultationProtocoll::setConsultationDuration()
     * @param string $agentSalutation
     * @param string $agentSurename
     * @param string $agentFirstname
     * @param string $agentGisaNr
     * @param string $agentSalesKind
     * @param string $agentIsuranceCompany
     * @param string $customerDemands
     * @param string $consultationDate
     * @param int $consultationDuration
     */
    public function __construct($agentSalutation = null, $agentSurename = null, $agentFirstname = null, $agentGisaNr = null, $agentSalesKind = null, $agentIsuranceCompany = null, $customerDemands = null, $consultationDate = null, $consultationDuration = null)
    {
        $this
            ->setAgentSalutation($agentSalutation)
            ->setAgentSurename($agentSurename)
            ->setAgentFirstname($agentFirstname)
            ->setAgentGisaNr($agentGisaNr)
            ->setAgentSalesKind($agentSalesKind)
            ->setAgentIsuranceCompany($agentIsuranceCompany)
            ->setCustomerDemands($customerDemands)
            ->setConsultationDate($consultationDate)
            ->setConsultationDuration($consultationDuration);
    }
    /**
     * Get agentSalutation value
     * @return string|null
     */
    public function getAgentSalutation()
    {
        return $this->agentSalutation;
    }
    /**
     * Set agentSalutation value
     * @param string $agentSalutation
     * @return \StructType\ConsultationProtocoll
     */
    public function setAgentSalutation($agentSalutation = null)
    {
        // validation for constraint: string
        if (!is_null($agentSalutation) && !is_string($agentSalutation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentSalutation, true), gettype($agentSalutation)), __LINE__);
        }
        $this->agentSalutation = $agentSalutation;
        return $this;
    }
    /**
     * Get agentSurename value
     * @return string|null
     */
    public function getAgentSurename()
    {
        return $this->agentSurename;
    }
    /**
     * Set agentSurename value
     * @param string $agentSurename
     * @return \StructType\ConsultationProtocoll
     */
    public function setAgentSurename($agentSurename = null)
    {
        // validation for constraint: string
        if (!is_null($agentSurename) && !is_string($agentSurename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentSurename, true), gettype($agentSurename)), __LINE__);
        }
        $this->agentSurename = $agentSurename;
        return $this;
    }
    /**
     * Get agentFirstname value
     * @return string|null
     */
    public function getAgentFirstname()
    {
        return $this->agentFirstname;
    }
    /**
     * Set agentFirstname value
     * @param string $agentFirstname
     * @return \StructType\ConsultationProtocoll
     */
    public function setAgentFirstname($agentFirstname = null)
    {
        // validation for constraint: string
        if (!is_null($agentFirstname) && !is_string($agentFirstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentFirstname, true), gettype($agentFirstname)), __LINE__);
        }
        $this->agentFirstname = $agentFirstname;
        return $this;
    }
    /**
     * Get agentGisaNr value
     * @return string|null
     */
    public function getAgentGisaNr()
    {
        return $this->agentGisaNr;
    }
    /**
     * Set agentGisaNr value
     * @param string $agentGisaNr
     * @return \StructType\ConsultationProtocoll
     */
    public function setAgentGisaNr($agentGisaNr = null)
    {
        // validation for constraint: string
        if (!is_null($agentGisaNr) && !is_string($agentGisaNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentGisaNr, true), gettype($agentGisaNr)), __LINE__);
        }
        $this->agentGisaNr = $agentGisaNr;
        return $this;
    }
    /**
     * Get agentSalesKind value
     * @return string|null
     */
    public function getAgentSalesKind()
    {
        return $this->agentSalesKind;
    }
    /**
     * Set agentSalesKind value
     * @param string $agentSalesKind
     * @return \StructType\ConsultationProtocoll
     */
    public function setAgentSalesKind($agentSalesKind = null)
    {
        // validation for constraint: string
        if (!is_null($agentSalesKind) && !is_string($agentSalesKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentSalesKind, true), gettype($agentSalesKind)), __LINE__);
        }
        $this->agentSalesKind = $agentSalesKind;
        return $this;
    }
    /**
     * Get agentIsuranceCompany value
     * @return string|null
     */
    public function getAgentIsuranceCompany()
    {
        return $this->agentIsuranceCompany;
    }
    /**
     * Set agentIsuranceCompany value
     * @param string $agentIsuranceCompany
     * @return \StructType\ConsultationProtocoll
     */
    public function setAgentIsuranceCompany($agentIsuranceCompany = null)
    {
        // validation for constraint: string
        if (!is_null($agentIsuranceCompany) && !is_string($agentIsuranceCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentIsuranceCompany, true), gettype($agentIsuranceCompany)), __LINE__);
        }
        $this->agentIsuranceCompany = $agentIsuranceCompany;
        return $this;
    }
    /**
     * Get customerDemands value
     * @return string|null
     */
    public function getCustomerDemands()
    {
        return $this->customerDemands;
    }
    /**
     * Set customerDemands value
     * @param string $customerDemands
     * @return \StructType\ConsultationProtocoll
     */
    public function setCustomerDemands($customerDemands = null)
    {
        // validation for constraint: string
        if (!is_null($customerDemands) && !is_string($customerDemands)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerDemands, true), gettype($customerDemands)), __LINE__);
        }
        $this->customerDemands = $customerDemands;
        return $this;
    }
    /**
     * Get consultationDate value
     * @return string|null
     */
    public function getConsultationDate()
    {
        return $this->consultationDate;
    }
    /**
     * Set consultationDate value
     * @param string $consultationDate
     * @return \StructType\ConsultationProtocoll
     */
    public function setConsultationDate($consultationDate = null)
    {
        // validation for constraint: string
        if (!is_null($consultationDate) && !is_string($consultationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consultationDate, true), gettype($consultationDate)), __LINE__);
        }
        $this->consultationDate = $consultationDate;
        return $this;
    }
    /**
     * Get consultationDuration value
     * @return int|null
     */
    public function getConsultationDuration()
    {
        return $this->consultationDuration;
    }
    /**
     * Set consultationDuration value
     * @param int $consultationDuration
     * @return \StructType\ConsultationProtocoll
     */
    public function setConsultationDuration($consultationDuration = null)
    {
        // validation for constraint: int
        if (!is_null($consultationDuration) && !(is_int($consultationDuration) || ctype_digit($consultationDuration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($consultationDuration, true), gettype($consultationDuration)), __LINE__);
        }
        $this->consultationDuration = $consultationDuration;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConsultationProtocoll
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
