<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommonData StructType
 * Meta information extracted from the WSDL
 * - documentation: Allgemeine Daten für die meisten Schadenmeldunge
 * @subpackage Structs
 */
class CommonData extends AbstractStructBase
{
    /**
     * The claimDate
     * @var string
     */
    public $claimDate;
    /**
     * The claimTime
     * @var string
     */
    public $claimTime;
    /**
     * The claimPlace
     * @var string
     */
    public $claimPlace;
    /**
     * The officialRecording
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $officialRecording;
    /**
     * The claimDescription
     * @var string
     */
    public $claimDescription;
    /**
     * Constructor method for CommonData
     * @uses CommonData::setClaimDate()
     * @uses CommonData::setClaimTime()
     * @uses CommonData::setClaimPlace()
     * @uses CommonData::setOfficialRecording()
     * @uses CommonData::setClaimDescription()
     * @param string $claimDate
     * @param string $claimTime
     * @param string $claimPlace
     * @param bool $officialRecording
     * @param string $claimDescription
     */
    public function __construct($claimDate = null, $claimTime = null, $claimPlace = null, $officialRecording = null, $claimDescription = null)
    {
        $this
            ->setClaimDate($claimDate)
            ->setClaimTime($claimTime)
            ->setClaimPlace($claimPlace)
            ->setOfficialRecording($officialRecording)
            ->setClaimDescription($claimDescription);
    }
    /**
     * Get claimDate value
     * @return string|null
     */
    public function getClaimDate()
    {
        return $this->claimDate;
    }
    /**
     * Set claimDate value
     * @param string $claimDate
     * @return \StructType\CommonData
     */
    public function setClaimDate($claimDate = null)
    {
        // validation for constraint: string
        if (!is_null($claimDate) && !is_string($claimDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claimDate, true), gettype($claimDate)), __LINE__);
        }
        $this->claimDate = $claimDate;
        return $this;
    }
    /**
     * Get claimTime value
     * @return string|null
     */
    public function getClaimTime()
    {
        return $this->claimTime;
    }
    /**
     * Set claimTime value
     * @param string $claimTime
     * @return \StructType\CommonData
     */
    public function setClaimTime($claimTime = null)
    {
        // validation for constraint: string
        if (!is_null($claimTime) && !is_string($claimTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claimTime, true), gettype($claimTime)), __LINE__);
        }
        $this->claimTime = $claimTime;
        return $this;
    }
    /**
     * Get claimPlace value
     * @return string|null
     */
    public function getClaimPlace()
    {
        return $this->claimPlace;
    }
    /**
     * Set claimPlace value
     * @param string $claimPlace
     * @return \StructType\CommonData
     */
    public function setClaimPlace($claimPlace = null)
    {
        // validation for constraint: string
        if (!is_null($claimPlace) && !is_string($claimPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claimPlace, true), gettype($claimPlace)), __LINE__);
        }
        $this->claimPlace = $claimPlace;
        return $this;
    }
    /**
     * Get officialRecording value
     * @return bool|null
     */
    public function getOfficialRecording()
    {
        return $this->officialRecording;
    }
    /**
     * Set officialRecording value
     * @param bool $officialRecording
     * @return \StructType\CommonData
     */
    public function setOfficialRecording($officialRecording = null)
    {
        // validation for constraint: boolean
        if (!is_null($officialRecording) && !is_bool($officialRecording)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($officialRecording, true), gettype($officialRecording)), __LINE__);
        }
        $this->officialRecording = $officialRecording;
        return $this;
    }
    /**
     * Get claimDescription value
     * @return string|null
     */
    public function getClaimDescription()
    {
        return $this->claimDescription;
    }
    /**
     * Set claimDescription value
     * @param string $claimDescription
     * @return \StructType\CommonData
     */
    public function setClaimDescription($claimDescription = null)
    {
        // validation for constraint: string
        if (!is_null($claimDescription) && !is_string($claimDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claimDescription, true), gettype($claimDescription)), __LINE__);
        }
        $this->claimDescription = $claimDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CommonData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
