<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClaimentPerson StructType
 * @subpackage Structs
 */
class ClaimentPerson extends AbstractStructBase
{
    /**
     * The anrede
     * @var string
     */
    public $anrede;
    /**
     * The vorname
     * @var string
     */
    public $vorname;
    /**
     * The nachname
     * @var string
     */
    public $nachname;
    /**
     * The adresse
     * @var \StructType\Adress
     */
    public $adresse;
    /**
     * The claimentContactData
     * @var \StructType\ClaimentContactData
     */
    public $claimentContactData;
    /**
     * Constructor method for ClaimentPerson
     * @uses ClaimentPerson::setAnrede()
     * @uses ClaimentPerson::setVorname()
     * @uses ClaimentPerson::setNachname()
     * @uses ClaimentPerson::setAdresse()
     * @uses ClaimentPerson::setClaimentContactData()
     * @param string $anrede
     * @param string $vorname
     * @param string $nachname
     * @param \StructType\Adress $adresse
     * @param \StructType\ClaimentContactData $claimentContactData
     */
    public function __construct($anrede = null, $vorname = null, $nachname = null, \StructType\Adress $adresse = null, \StructType\ClaimentContactData $claimentContactData = null)
    {
        $this
            ->setAnrede($anrede)
            ->setVorname($vorname)
            ->setNachname($nachname)
            ->setAdresse($adresse)
            ->setClaimentContactData($claimentContactData);
    }
    /**
     * Get anrede value
     * @return string|null
     */
    public function getAnrede()
    {
        return $this->anrede;
    }
    /**
     * Set anrede value
     * @uses \EnumType\ClaimentAnrede::valueIsValid()
     * @uses \EnumType\ClaimentAnrede::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $anrede
     * @return \StructType\ClaimentPerson
     */
    public function setAnrede($anrede = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ClaimentAnrede::valueIsValid($anrede)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ClaimentAnrede', is_array($anrede) ? implode(', ', $anrede) : var_export($anrede, true), implode(', ', \EnumType\ClaimentAnrede::getValidValues())), __LINE__);
        }
        $this->anrede = $anrede;
        return $this;
    }
    /**
     * Get vorname value
     * @return string|null
     */
    public function getVorname()
    {
        return $this->vorname;
    }
    /**
     * Set vorname value
     * @param string $vorname
     * @return \StructType\ClaimentPerson
     */
    public function setVorname($vorname = null)
    {
        // validation for constraint: string
        if (!is_null($vorname) && !is_string($vorname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorname, true), gettype($vorname)), __LINE__);
        }
        $this->vorname = $vorname;
        return $this;
    }
    /**
     * Get nachname value
     * @return string|null
     */
    public function getNachname()
    {
        return $this->nachname;
    }
    /**
     * Set nachname value
     * @param string $nachname
     * @return \StructType\ClaimentPerson
     */
    public function setNachname($nachname = null)
    {
        // validation for constraint: string
        if (!is_null($nachname) && !is_string($nachname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nachname, true), gettype($nachname)), __LINE__);
        }
        $this->nachname = $nachname;
        return $this;
    }
    /**
     * Get adresse value
     * @return \StructType\Adress|null
     */
    public function getAdresse()
    {
        return $this->adresse;
    }
    /**
     * Set adresse value
     * @param \StructType\Adress $adresse
     * @return \StructType\ClaimentPerson
     */
    public function setAdresse(\StructType\Adress $adresse = null)
    {
        $this->adresse = $adresse;
        return $this;
    }
    /**
     * Get claimentContactData value
     * @return \StructType\ClaimentContactData|null
     */
    public function getClaimentContactData()
    {
        return $this->claimentContactData;
    }
    /**
     * Set claimentContactData value
     * @param \StructType\ClaimentContactData $claimentContactData
     * @return \StructType\ClaimentPerson
     */
    public function setClaimentContactData(\StructType\ClaimentContactData $claimentContactData = null)
    {
        $this->claimentContactData = $claimentContactData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClaimentPerson
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
