<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Claiment StructType
 * @subpackage Structs
 */
class Claiment extends AbstractStructBase
{
    /**
     * The claimentIs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $claimentIs;
    /**
     * The claimentFirma
     * Meta information extracted from the WSDL
     * - choice: claimentFirma | claimentPerson | claimentMehrere
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var \StructType\ClaimentFirma
     */
    public $claimentFirma;
    /**
     * The claimentPerson
     * Meta information extracted from the WSDL
     * - choice: claimentFirma | claimentPerson | claimentMehrere
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * @var \StructType\ClaimentPerson
     */
    public $claimentPerson;
    /**
     * The claimentMehrere
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: claimentFirma | claimentPerson | claimentMehrere
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxLength: 1024
     * - minLength: 1
     * @var string
     */
    public $claimentMehrere;
    /**
     * Constructor method for Claiment
     * @uses Claiment::setClaimentIs()
     * @uses Claiment::setClaimentFirma()
     * @uses Claiment::setClaimentPerson()
     * @uses Claiment::setClaimentMehrere()
     * @param string $claimentIs
     * @param \StructType\ClaimentFirma $claimentFirma
     * @param \StructType\ClaimentPerson $claimentPerson
     * @param string $claimentMehrere
     */
    public function __construct($claimentIs = null, \StructType\ClaimentFirma $claimentFirma = null, \StructType\ClaimentPerson $claimentPerson = null, $claimentMehrere = null)
    {
        $this
            ->setClaimentIs($claimentIs)
            ->setClaimentFirma($claimentFirma)
            ->setClaimentPerson($claimentPerson)
            ->setClaimentMehrere($claimentMehrere);
    }
    /**
     * Get claimentIs value
     * @return string|null
     */
    public function getClaimentIs()
    {
        return $this->claimentIs;
    }
    /**
     * Set claimentIs value
     * @uses \EnumType\ClaimentIs::valueIsValid()
     * @uses \EnumType\ClaimentIs::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $claimentIs
     * @return \StructType\Claiment
     */
    public function setClaimentIs($claimentIs = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ClaimentIs::valueIsValid($claimentIs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ClaimentIs', is_array($claimentIs) ? implode(', ', $claimentIs) : var_export($claimentIs, true), implode(', ', \EnumType\ClaimentIs::getValidValues())), __LINE__);
        }
        $this->claimentIs = $claimentIs;
        return $this;
    }
    /**
     * Get claimentFirma value
     * @return \StructType\ClaimentFirma|null
     */
    public function getClaimentFirma()
    {
        return isset($this->claimentFirma) ? $this->claimentFirma : null;
    }
    /**
     * This method is responsible for validating the value passed to the setClaimentFirma method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClaimentFirma method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateClaimentFirmaForChoiceConstraintsFromSetClaimentFirma($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'claimentPerson',
            'claimentMehrere',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property claimentFirma can\'t be set as the property %s is already set. Only one property must be set among these properties: claimentFirma, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set claimentFirma value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ClaimentFirma $claimentFirma
     * @return \StructType\Claiment
     */
    public function setClaimentFirma(\StructType\ClaimentFirma $claimentFirma = null)
    {
        // validation for constraint: choice(claimentFirma, claimentPerson, claimentMehrere)
        if ('' !== ($claimentFirmaChoiceErrorMessage = self::validateClaimentFirmaForChoiceConstraintsFromSetClaimentFirma($claimentFirma))) {
            throw new \InvalidArgumentException($claimentFirmaChoiceErrorMessage, __LINE__);
        }
        if (is_null($claimentFirma) || (is_array($claimentFirma) && empty($claimentFirma))) {
            unset($this->claimentFirma);
        } else {
            $this->claimentFirma = $claimentFirma;
        }
        return $this;
    }
    /**
     * Get claimentPerson value
     * @return \StructType\ClaimentPerson|null
     */
    public function getClaimentPerson()
    {
        return isset($this->claimentPerson) ? $this->claimentPerson : null;
    }
    /**
     * This method is responsible for validating the value passed to the setClaimentPerson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClaimentPerson method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateClaimentPersonForChoiceConstraintsFromSetClaimentPerson($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'claimentFirma',
            'claimentMehrere',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property claimentPerson can\'t be set as the property %s is already set. Only one property must be set among these properties: claimentPerson, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set claimentPerson value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ClaimentPerson $claimentPerson
     * @return \StructType\Claiment
     */
    public function setClaimentPerson(\StructType\ClaimentPerson $claimentPerson = null)
    {
        // validation for constraint: choice(claimentFirma, claimentPerson, claimentMehrere)
        if ('' !== ($claimentPersonChoiceErrorMessage = self::validateClaimentPersonForChoiceConstraintsFromSetClaimentPerson($claimentPerson))) {
            throw new \InvalidArgumentException($claimentPersonChoiceErrorMessage, __LINE__);
        }
        if (is_null($claimentPerson) || (is_array($claimentPerson) && empty($claimentPerson))) {
            unset($this->claimentPerson);
        } else {
            $this->claimentPerson = $claimentPerson;
        }
        return $this;
    }
    /**
     * Get claimentMehrere value
     * @return string|null
     */
    public function getClaimentMehrere()
    {
        return isset($this->claimentMehrere) ? $this->claimentMehrere : null;
    }
    /**
     * This method is responsible for validating the value passed to the setClaimentMehrere method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClaimentMehrere method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateClaimentMehrereForChoiceConstraintsFromSetClaimentMehrere($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'claimentFirma',
            'claimentPerson',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property claimentMehrere can\'t be set as the property %s is already set. Only one property must be set among these properties: claimentMehrere, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set claimentMehrere value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $claimentMehrere
     * @return \StructType\Claiment
     */
    public function setClaimentMehrere($claimentMehrere = null)
    {
        // validation for constraint: string
        if (!is_null($claimentMehrere) && !is_string($claimentMehrere)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($claimentMehrere, true), gettype($claimentMehrere)), __LINE__);
        }
        // validation for constraint: choice(claimentFirma, claimentPerson, claimentMehrere)
        if ('' !== ($claimentMehrereChoiceErrorMessage = self::validateClaimentMehrereForChoiceConstraintsFromSetClaimentMehrere($claimentMehrere))) {
            throw new \InvalidArgumentException($claimentMehrereChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(1024)
        if (!is_null($claimentMehrere) && mb_strlen($claimentMehrere) > 1024) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1024', mb_strlen($claimentMehrere)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($claimentMehrere) && mb_strlen($claimentMehrere) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($claimentMehrere)), __LINE__);
        }
        if (is_null($claimentMehrere) || (is_array($claimentMehrere) && empty($claimentMehrere))) {
            unset($this->claimentMehrere);
        } else {
            $this->claimentMehrere = $claimentMehrere;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Claiment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
