<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for carInsurance StructType
 * @subpackage Structs
 */
class CarInsurance extends AbstractStructBase
{
    /**
     * The general
     * @var \StructType\CommonData
     */
    public $general;
    /**
     * The licencePlateNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $licencePlateNumber;
    /**
     * The driver
     * @var \StructType\Driver
     */
    public $driver;
    /**
     * Constructor method for carInsurance
     * @uses CarInsurance::setGeneral()
     * @uses CarInsurance::setLicencePlateNumber()
     * @uses CarInsurance::setDriver()
     * @param \StructType\CommonData $general
     * @param string $licencePlateNumber
     * @param \StructType\Driver $driver
     */
    public function __construct(\StructType\CommonData $general = null, $licencePlateNumber = null, \StructType\Driver $driver = null)
    {
        $this
            ->setGeneral($general)
            ->setLicencePlateNumber($licencePlateNumber)
            ->setDriver($driver);
    }
    /**
     * Get general value
     * @return \StructType\CommonData|null
     */
    public function getGeneral()
    {
        return $this->general;
    }
    /**
     * Set general value
     * @param \StructType\CommonData $general
     * @return \StructType\CarInsurance
     */
    public function setGeneral(\StructType\CommonData $general = null)
    {
        $this->general = $general;
        return $this;
    }
    /**
     * Get licencePlateNumber value
     * @return string|null
     */
    public function getLicencePlateNumber()
    {
        return $this->licencePlateNumber;
    }
    /**
     * Set licencePlateNumber value
     * @param string $licencePlateNumber
     * @return \StructType\CarInsurance
     */
    public function setLicencePlateNumber($licencePlateNumber = null)
    {
        // validation for constraint: string
        if (!is_null($licencePlateNumber) && !is_string($licencePlateNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licencePlateNumber, true), gettype($licencePlateNumber)), __LINE__);
        }
        $this->licencePlateNumber = $licencePlateNumber;
        return $this;
    }
    /**
     * Get driver value
     * @return \StructType\Driver|null
     */
    public function getDriver()
    {
        return $this->driver;
    }
    /**
     * Set driver value
     * @param \StructType\Driver $driver
     * @return \StructType\CarInsurance
     */
    public function setDriver(\StructType\Driver $driver = null)
    {
        $this->driver = $driver;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CarInsurance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
