<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for calculatePremiumOnlyRequest StructType
 * @subpackage Structs
 */
class CalculatePremiumOnlyRequest extends AbstractStructBase
{
    /**
     * The login
     * @var \StructType\Login
     */
    public $login;
    /**
     * The customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Customer
     */
    public $customer;
    /**
     * The businessCaseType
     * @var string
     */
    public $businessCaseType;
    /**
     * The attribute
     * Meta information extracted from the WSDL
     * - choice: attribute | generalikfzv2 | generaliprivat
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * @var \StructType\Attribute[]
     */
    public $attribute;
    /**
     * The generalikfzv2
     * Meta information extracted from the WSDL
     * - choice: attribute | generalikfzv2 | generaliprivat
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Generalikfzv2Type
     */
    public $generalikfzv2;
    /**
     * The generaliprivat
     * Meta information extracted from the WSDL
     * - choice: attribute | generalikfzv2 | generaliprivat
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\GeneraliprivatType
     */
    public $generaliprivat;
    /**
     * The frameAgreementNr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $frameAgreementNr;
    /**
     * Constructor method for calculatePremiumOnlyRequest
     * @uses CalculatePremiumOnlyRequest::setLogin()
     * @uses CalculatePremiumOnlyRequest::setCustomer()
     * @uses CalculatePremiumOnlyRequest::setBusinessCaseType()
     * @uses CalculatePremiumOnlyRequest::setAttribute()
     * @uses CalculatePremiumOnlyRequest::setGeneralikfzv2()
     * @uses CalculatePremiumOnlyRequest::setGeneraliprivat()
     * @uses CalculatePremiumOnlyRequest::setFrameAgreementNr()
     * @param \StructType\Login $login
     * @param \StructType\Customer $customer
     * @param string $businessCaseType
     * @param \StructType\Attribute[] $attribute
     * @param \StructType\Generalikfzv2Type $generalikfzv2
     * @param \StructType\GeneraliprivatType $generaliprivat
     * @param string $frameAgreementNr
     */
    public function __construct(\StructType\Login $login = null, \StructType\Customer $customer = null, $businessCaseType = null, array $attribute = array(), \StructType\Generalikfzv2Type $generalikfzv2 = null, \StructType\GeneraliprivatType $generaliprivat = null, $frameAgreementNr = null)
    {
        $this
            ->setLogin($login)
            ->setCustomer($customer)
            ->setBusinessCaseType($businessCaseType)
            ->setAttribute($attribute)
            ->setGeneralikfzv2($generalikfzv2)
            ->setGeneraliprivat($generaliprivat)
            ->setFrameAgreementNr($frameAgreementNr);
    }
    /**
     * Get login value
     * @return \StructType\Login|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param \StructType\Login $login
     * @return \StructType\CalculatePremiumOnlyRequest
     */
    public function setLogin(\StructType\Login $login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get customer value
     * @return \StructType\Customer|null
     */
    public function getCustomer()
    {
        return $this->customer;
    }
    /**
     * Set customer value
     * @param \StructType\Customer $customer
     * @return \StructType\CalculatePremiumOnlyRequest
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        $this->customer = $customer;
        return $this;
    }
    /**
     * Get businessCaseType value
     * @return string|null
     */
    public function getBusinessCaseType()
    {
        return $this->businessCaseType;
    }
    /**
     * Set businessCaseType value
     * @uses \EnumType\BusinessCaseType::valueIsValid()
     * @uses \EnumType\BusinessCaseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $businessCaseType
     * @return \StructType\CalculatePremiumOnlyRequest
     */
    public function setBusinessCaseType($businessCaseType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusinessCaseType::valueIsValid($businessCaseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BusinessCaseType', is_array($businessCaseType) ? implode(', ', $businessCaseType) : var_export($businessCaseType, true), implode(', ', \EnumType\BusinessCaseType::getValidValues())), __LINE__);
        }
        $this->businessCaseType = $businessCaseType;
        return $this;
    }
    /**
     * Get attribute value
     * @return \StructType\Attribute[]|null
     */
    public function getAttribute()
    {
        return isset($this->attribute) ? $this->attribute : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttribute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttributeForArrayConstraintsFromSetAttribute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $calculatePremiumOnlyRequestAttributeItem) {
            // validation for constraint: itemType
            if (!$calculatePremiumOnlyRequestAttributeItem instanceof \StructType\Attribute) {
                $invalidValues[] = is_object($calculatePremiumOnlyRequestAttributeItem) ? get_class($calculatePremiumOnlyRequestAttributeItem) : sprintf('%s(%s)', gettype($calculatePremiumOnlyRequestAttributeItem), var_export($calculatePremiumOnlyRequestAttributeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The attribute property can only contain items of type \StructType\Attribute, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttribute method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAttributeForChoiceConstraintsFromSetAttribute($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'generalikfzv2',
            'generaliprivat',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property attribute can\'t be set as the property %s is already set. Only one property must be set among these properties: attribute, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set attribute value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Attribute[] $attribute
     * @return \StructType\CalculatePremiumOnlyRequest
     */
    public function setAttribute(array $attribute = array())
    {
        // validation for constraint: array
        if ('' !== ($attributeArrayErrorMessage = self::validateAttributeForArrayConstraintsFromSetAttribute($attribute))) {
            throw new \InvalidArgumentException($attributeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(attribute, generalikfzv2, generaliprivat)
        if ('' !== ($attributeChoiceErrorMessage = self::validateAttributeForChoiceConstraintsFromSetAttribute($attribute))) {
            throw new \InvalidArgumentException($attributeChoiceErrorMessage, __LINE__);
        }
        if (is_null($attribute) || (is_array($attribute) && empty($attribute))) {
            unset($this->attribute);
        } else {
            $this->attribute = $attribute;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToAttribute method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToAttribute($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'generalikfzv2',
            'generaliprivat',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property attribute can\'t be set as the property %s is already set. Only one property must be set among these properties: attribute, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to attribute value
     * @throws \InvalidArgumentException
     * @param \StructType\Attribute $item
     * @return \StructType\CalculatePremiumOnlyRequest
     */
    public function addToAttribute(\StructType\Attribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attribute) {
            throw new \InvalidArgumentException(sprintf('The attribute property can only contain items of type \StructType\Attribute, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(attribute, generalikfzv2, generaliprivat)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToAttribute($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->attribute[] = $item;
        return $this;
    }
    /**
     * Get generalikfzv2 value
     * @return \StructType\Generalikfzv2Type|null
     */
    public function getGeneralikfzv2()
    {
        return isset($this->generalikfzv2) ? $this->generalikfzv2 : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGeneralikfzv2 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGeneralikfzv2 method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGeneralikfzv2ForChoiceConstraintsFromSetGeneralikfzv2($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'attribute',
            'generaliprivat',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property generalikfzv2 can\'t be set as the property %s is already set. Only one property must be set among these properties: generalikfzv2, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set generalikfzv2 value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Generalikfzv2Type $generalikfzv2
     * @return \StructType\CalculatePremiumOnlyRequest
     */
    public function setGeneralikfzv2(\StructType\Generalikfzv2Type $generalikfzv2 = null)
    {
        // validation for constraint: choice(attribute, generalikfzv2, generaliprivat)
        if ('' !== ($generalikfzv2ChoiceErrorMessage = self::validateGeneralikfzv2ForChoiceConstraintsFromSetGeneralikfzv2($generalikfzv2))) {
            throw new \InvalidArgumentException($generalikfzv2ChoiceErrorMessage, __LINE__);
        }
        if (is_null($generalikfzv2) || (is_array($generalikfzv2) && empty($generalikfzv2))) {
            unset($this->generalikfzv2);
        } else {
            $this->generalikfzv2 = $generalikfzv2;
        }
        return $this;
    }
    /**
     * Get generaliprivat value
     * @return \StructType\GeneraliprivatType|null
     */
    public function getGeneraliprivat()
    {
        return isset($this->generaliprivat) ? $this->generaliprivat : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGeneraliprivat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGeneraliprivat method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGeneraliprivatForChoiceConstraintsFromSetGeneraliprivat($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'attribute',
            'generalikfzv2',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property generaliprivat can\'t be set as the property %s is already set. Only one property must be set among these properties: generaliprivat, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set generaliprivat value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GeneraliprivatType $generaliprivat
     * @return \StructType\CalculatePremiumOnlyRequest
     */
    public function setGeneraliprivat(\StructType\GeneraliprivatType $generaliprivat = null)
    {
        // validation for constraint: choice(attribute, generalikfzv2, generaliprivat)
        if ('' !== ($generaliprivatChoiceErrorMessage = self::validateGeneraliprivatForChoiceConstraintsFromSetGeneraliprivat($generaliprivat))) {
            throw new \InvalidArgumentException($generaliprivatChoiceErrorMessage, __LINE__);
        }
        if (is_null($generaliprivat) || (is_array($generaliprivat) && empty($generaliprivat))) {
            unset($this->generaliprivat);
        } else {
            $this->generaliprivat = $generaliprivat;
        }
        return $this;
    }
    /**
     * Get frameAgreementNr value
     * @return string|null
     */
    public function getFrameAgreementNr()
    {
        return $this->frameAgreementNr;
    }
    /**
     * Set frameAgreementNr value
     * @param string $frameAgreementNr
     * @return \StructType\CalculatePremiumOnlyRequest
     */
    public function setFrameAgreementNr($frameAgreementNr = null)
    {
        // validation for constraint: string
        if (!is_null($frameAgreementNr) && !is_string($frameAgreementNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frameAgreementNr, true), gettype($frameAgreementNr)), __LINE__);
        }
        $this->frameAgreementNr = $frameAgreementNr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CalculatePremiumOnlyRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
