<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BonusMalus StructType
 * @subpackage Structs
 */
class BonusMalus extends AbstractStructBase
{
    /**
     * The bmLevel
     * Meta information extracted from the WSDL
     * - documentation: For Generali: 0 to 17
     * @var int
     */
    public $bmLevel;
    /**
     * The policyNumber
     * Meta information extracted from the WSDL
     * - documentation: is required if 'bmLevel' is not 9.
     * - minOccurs: 0
     * @var string
     */
    public $policyNumber;
    /**
     * The insuranceCompany
     * Meta information extracted from the WSDL
     * - documentation: is required if 'bmLevel' is not 9.
     * - minOccurs: 0
     * @var string
     */
    public $insuranceCompany;
    /**
     * The openClaimMonth1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $openClaimMonth1;
    /**
     * The openClaimYear1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $openClaimYear1;
    /**
     * The openClaimMonth2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $openClaimMonth2;
    /**
     * The openClaimYear2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $openClaimYear2;
    /**
     * The openClaimMonth3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $openClaimMonth3;
    /**
     * The openClaimYear3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $openClaimYear3;
    /**
     * Constructor method for BonusMalus
     * @uses BonusMalus::setBmLevel()
     * @uses BonusMalus::setPolicyNumber()
     * @uses BonusMalus::setInsuranceCompany()
     * @uses BonusMalus::setOpenClaimMonth1()
     * @uses BonusMalus::setOpenClaimYear1()
     * @uses BonusMalus::setOpenClaimMonth2()
     * @uses BonusMalus::setOpenClaimYear2()
     * @uses BonusMalus::setOpenClaimMonth3()
     * @uses BonusMalus::setOpenClaimYear3()
     * @param int $bmLevel
     * @param string $policyNumber
     * @param string $insuranceCompany
     * @param int $openClaimMonth1
     * @param int $openClaimYear1
     * @param int $openClaimMonth2
     * @param int $openClaimYear2
     * @param int $openClaimMonth3
     * @param int $openClaimYear3
     */
    public function __construct($bmLevel = null, $policyNumber = null, $insuranceCompany = null, $openClaimMonth1 = null, $openClaimYear1 = null, $openClaimMonth2 = null, $openClaimYear2 = null, $openClaimMonth3 = null, $openClaimYear3 = null)
    {
        $this
            ->setBmLevel($bmLevel)
            ->setPolicyNumber($policyNumber)
            ->setInsuranceCompany($insuranceCompany)
            ->setOpenClaimMonth1($openClaimMonth1)
            ->setOpenClaimYear1($openClaimYear1)
            ->setOpenClaimMonth2($openClaimMonth2)
            ->setOpenClaimYear2($openClaimYear2)
            ->setOpenClaimMonth3($openClaimMonth3)
            ->setOpenClaimYear3($openClaimYear3);
    }
    /**
     * Get bmLevel value
     * @return int|null
     */
    public function getBmLevel()
    {
        return $this->bmLevel;
    }
    /**
     * Set bmLevel value
     * @param int $bmLevel
     * @return \StructType\BonusMalus
     */
    public function setBmLevel($bmLevel = null)
    {
        // validation for constraint: int
        if (!is_null($bmLevel) && !(is_int($bmLevel) || ctype_digit($bmLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bmLevel, true), gettype($bmLevel)), __LINE__);
        }
        $this->bmLevel = $bmLevel;
        return $this;
    }
    /**
     * Get policyNumber value
     * @return string|null
     */
    public function getPolicyNumber()
    {
        return $this->policyNumber;
    }
    /**
     * Set policyNumber value
     * @param string $policyNumber
     * @return \StructType\BonusMalus
     */
    public function setPolicyNumber($policyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($policyNumber) && !is_string($policyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyNumber, true), gettype($policyNumber)), __LINE__);
        }
        $this->policyNumber = $policyNumber;
        return $this;
    }
    /**
     * Get insuranceCompany value
     * @return string|null
     */
    public function getInsuranceCompany()
    {
        return $this->insuranceCompany;
    }
    /**
     * Set insuranceCompany value
     * @param string $insuranceCompany
     * @return \StructType\BonusMalus
     */
    public function setInsuranceCompany($insuranceCompany = null)
    {
        // validation for constraint: string
        if (!is_null($insuranceCompany) && !is_string($insuranceCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insuranceCompany, true), gettype($insuranceCompany)), __LINE__);
        }
        $this->insuranceCompany = $insuranceCompany;
        return $this;
    }
    /**
     * Get openClaimMonth1 value
     * @return int|null
     */
    public function getOpenClaimMonth1()
    {
        return $this->openClaimMonth1;
    }
    /**
     * Set openClaimMonth1 value
     * @param int $openClaimMonth1
     * @return \StructType\BonusMalus
     */
    public function setOpenClaimMonth1($openClaimMonth1 = null)
    {
        // validation for constraint: int
        if (!is_null($openClaimMonth1) && !(is_int($openClaimMonth1) || ctype_digit($openClaimMonth1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($openClaimMonth1, true), gettype($openClaimMonth1)), __LINE__);
        }
        $this->openClaimMonth1 = $openClaimMonth1;
        return $this;
    }
    /**
     * Get openClaimYear1 value
     * @return int|null
     */
    public function getOpenClaimYear1()
    {
        return $this->openClaimYear1;
    }
    /**
     * Set openClaimYear1 value
     * @param int $openClaimYear1
     * @return \StructType\BonusMalus
     */
    public function setOpenClaimYear1($openClaimYear1 = null)
    {
        // validation for constraint: int
        if (!is_null($openClaimYear1) && !(is_int($openClaimYear1) || ctype_digit($openClaimYear1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($openClaimYear1, true), gettype($openClaimYear1)), __LINE__);
        }
        $this->openClaimYear1 = $openClaimYear1;
        return $this;
    }
    /**
     * Get openClaimMonth2 value
     * @return int|null
     */
    public function getOpenClaimMonth2()
    {
        return $this->openClaimMonth2;
    }
    /**
     * Set openClaimMonth2 value
     * @param int $openClaimMonth2
     * @return \StructType\BonusMalus
     */
    public function setOpenClaimMonth2($openClaimMonth2 = null)
    {
        // validation for constraint: int
        if (!is_null($openClaimMonth2) && !(is_int($openClaimMonth2) || ctype_digit($openClaimMonth2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($openClaimMonth2, true), gettype($openClaimMonth2)), __LINE__);
        }
        $this->openClaimMonth2 = $openClaimMonth2;
        return $this;
    }
    /**
     * Get openClaimYear2 value
     * @return int|null
     */
    public function getOpenClaimYear2()
    {
        return $this->openClaimYear2;
    }
    /**
     * Set openClaimYear2 value
     * @param int $openClaimYear2
     * @return \StructType\BonusMalus
     */
    public function setOpenClaimYear2($openClaimYear2 = null)
    {
        // validation for constraint: int
        if (!is_null($openClaimYear2) && !(is_int($openClaimYear2) || ctype_digit($openClaimYear2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($openClaimYear2, true), gettype($openClaimYear2)), __LINE__);
        }
        $this->openClaimYear2 = $openClaimYear2;
        return $this;
    }
    /**
     * Get openClaimMonth3 value
     * @return int|null
     */
    public function getOpenClaimMonth3()
    {
        return $this->openClaimMonth3;
    }
    /**
     * Set openClaimMonth3 value
     * @param int $openClaimMonth3
     * @return \StructType\BonusMalus
     */
    public function setOpenClaimMonth3($openClaimMonth3 = null)
    {
        // validation for constraint: int
        if (!is_null($openClaimMonth3) && !(is_int($openClaimMonth3) || ctype_digit($openClaimMonth3))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($openClaimMonth3, true), gettype($openClaimMonth3)), __LINE__);
        }
        $this->openClaimMonth3 = $openClaimMonth3;
        return $this;
    }
    /**
     * Get openClaimYear3 value
     * @return int|null
     */
    public function getOpenClaimYear3()
    {
        return $this->openClaimYear3;
    }
    /**
     * Set openClaimYear3 value
     * @param int $openClaimYear3
     * @return \StructType\BonusMalus
     */
    public function setOpenClaimYear3($openClaimYear3 = null)
    {
        // validation for constraint: int
        if (!is_null($openClaimYear3) && !(is_int($openClaimYear3) || ctype_digit($openClaimYear3))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($openClaimYear3, true), gettype($openClaimYear3)), __LINE__);
        }
        $this->openClaimYear3 = $openClaimYear3;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BonusMalus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
