<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BerechnungswerteType StructType
 * @subpackage Structs
 */
class BerechnungswerteType extends AbstractStructBase
{
    /**
     * The polizzennummer
     * @var string
     */
    public $polizzennummer;
    /**
     * The bearbeitungok
     * @var bool
     */
    public $bearbeitungok;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The berechnungsdatum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $berechnungsdatum;
    /**
     * The erlebenswert
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $erlebenswert;
    /**
     * The ablebenswert
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ablebenswert;
    /**
     * The rueckkaufswert
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $rueckkaufswert;
    /**
     * Constructor method for BerechnungswerteType
     * @uses BerechnungswerteType::setPolizzennummer()
     * @uses BerechnungswerteType::setBearbeitungok()
     * @uses BerechnungswerteType::setMessage()
     * @uses BerechnungswerteType::setBerechnungsdatum()
     * @uses BerechnungswerteType::setErlebenswert()
     * @uses BerechnungswerteType::setAblebenswert()
     * @uses BerechnungswerteType::setRueckkaufswert()
     * @param string $polizzennummer
     * @param bool $bearbeitungok
     * @param string $message
     * @param string $berechnungsdatum
     * @param float $erlebenswert
     * @param float $ablebenswert
     * @param float $rueckkaufswert
     */
    public function __construct($polizzennummer = null, $bearbeitungok = null, $message = null, $berechnungsdatum = null, $erlebenswert = null, $ablebenswert = null, $rueckkaufswert = null)
    {
        $this
            ->setPolizzennummer($polizzennummer)
            ->setBearbeitungok($bearbeitungok)
            ->setMessage($message)
            ->setBerechnungsdatum($berechnungsdatum)
            ->setErlebenswert($erlebenswert)
            ->setAblebenswert($ablebenswert)
            ->setRueckkaufswert($rueckkaufswert);
    }
    /**
     * Get polizzennummer value
     * @return string|null
     */
    public function getPolizzennummer()
    {
        return $this->polizzennummer;
    }
    /**
     * Set polizzennummer value
     * @param string $polizzennummer
     * @return \StructType\BerechnungswerteType
     */
    public function setPolizzennummer($polizzennummer = null)
    {
        // validation for constraint: string
        if (!is_null($polizzennummer) && !is_string($polizzennummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($polizzennummer, true), gettype($polizzennummer)), __LINE__);
        }
        $this->polizzennummer = $polizzennummer;
        return $this;
    }
    /**
     * Get bearbeitungok value
     * @return bool|null
     */
    public function getBearbeitungok()
    {
        return $this->bearbeitungok;
    }
    /**
     * Set bearbeitungok value
     * @param bool $bearbeitungok
     * @return \StructType\BerechnungswerteType
     */
    public function setBearbeitungok($bearbeitungok = null)
    {
        // validation for constraint: boolean
        if (!is_null($bearbeitungok) && !is_bool($bearbeitungok)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bearbeitungok, true), gettype($bearbeitungok)), __LINE__);
        }
        $this->bearbeitungok = $bearbeitungok;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\BerechnungswerteType
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get berechnungsdatum value
     * @return string|null
     */
    public function getBerechnungsdatum()
    {
        return $this->berechnungsdatum;
    }
    /**
     * Set berechnungsdatum value
     * @param string $berechnungsdatum
     * @return \StructType\BerechnungswerteType
     */
    public function setBerechnungsdatum($berechnungsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($berechnungsdatum) && !is_string($berechnungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($berechnungsdatum, true), gettype($berechnungsdatum)), __LINE__);
        }
        $this->berechnungsdatum = $berechnungsdatum;
        return $this;
    }
    /**
     * Get erlebenswert value
     * @return float|null
     */
    public function getErlebenswert()
    {
        return $this->erlebenswert;
    }
    /**
     * Set erlebenswert value
     * @param float $erlebenswert
     * @return \StructType\BerechnungswerteType
     */
    public function setErlebenswert($erlebenswert = null)
    {
        // validation for constraint: float
        if (!is_null($erlebenswert) && !(is_float($erlebenswert) || is_numeric($erlebenswert))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($erlebenswert, true), gettype($erlebenswert)), __LINE__);
        }
        $this->erlebenswert = $erlebenswert;
        return $this;
    }
    /**
     * Get ablebenswert value
     * @return float|null
     */
    public function getAblebenswert()
    {
        return $this->ablebenswert;
    }
    /**
     * Set ablebenswert value
     * @param float $ablebenswert
     * @return \StructType\BerechnungswerteType
     */
    public function setAblebenswert($ablebenswert = null)
    {
        // validation for constraint: float
        if (!is_null($ablebenswert) && !(is_float($ablebenswert) || is_numeric($ablebenswert))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ablebenswert, true), gettype($ablebenswert)), __LINE__);
        }
        $this->ablebenswert = $ablebenswert;
        return $this;
    }
    /**
     * Get rueckkaufswert value
     * @return float|null
     */
    public function getRueckkaufswert()
    {
        return $this->rueckkaufswert;
    }
    /**
     * Set rueckkaufswert value
     * @param float $rueckkaufswert
     * @return \StructType\BerechnungswerteType
     */
    public function setRueckkaufswert($rueckkaufswert = null)
    {
        // validation for constraint: float
        if (!is_null($rueckkaufswert) && !(is_float($rueckkaufswert) || is_numeric($rueckkaufswert))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rueckkaufswert, true), gettype($rueckkaufswert)), __LINE__);
        }
        $this->rueckkaufswert = $rueckkaufswert;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BerechnungswerteType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
