<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BehandlerArtKP StructType
 * Meta information extracted from the WSDL
 * - documentation: Behandlerart KP
 * @subpackage Structs
 */
class BehandlerArtKP extends AbstractStructBase
{
    /**
     * The treatmentType
     * Meta information extracted from the WSDL
     * - documentation: Art des Behandlers/Behandlergrundtypus
     * - minOccurs: 0
     * @var string
     */
    public $treatmentType;
    /**
     * The handlerCode
     * Meta information extracted from the WSDL
     * - documentation: Schlüssel für Datenübertragung
     * - minOccurs: 0
     * @var string
     */
    public $handlerCode;
    /**
     * The handlerDescription
     * Meta information extracted from the WSDL
     * - documentation: Landtext
     * - minOccurs: 0
     * @var string
     */
    public $handlerDescription;
    /**
     * The handlerID
     * Meta information extracted from the WSDL
     * - documentation: PractionerCode
     * - minOccurs: 0
     * @var string
     */
    public $handlerID;
    /**
     * Constructor method for BehandlerArtKP
     * @uses BehandlerArtKP::setTreatmentType()
     * @uses BehandlerArtKP::setHandlerCode()
     * @uses BehandlerArtKP::setHandlerDescription()
     * @uses BehandlerArtKP::setHandlerID()
     * @param string $treatmentType
     * @param string $handlerCode
     * @param string $handlerDescription
     * @param string $handlerID
     */
    public function __construct($treatmentType = null, $handlerCode = null, $handlerDescription = null, $handlerID = null)
    {
        $this
            ->setTreatmentType($treatmentType)
            ->setHandlerCode($handlerCode)
            ->setHandlerDescription($handlerDescription)
            ->setHandlerID($handlerID);
    }
    /**
     * Get treatmentType value
     * @return string|null
     */
    public function getTreatmentType()
    {
        return $this->treatmentType;
    }
    /**
     * Set treatmentType value
     * @param string $treatmentType
     * @return \StructType\BehandlerArtKP
     */
    public function setTreatmentType($treatmentType = null)
    {
        // validation for constraint: string
        if (!is_null($treatmentType) && !is_string($treatmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($treatmentType, true), gettype($treatmentType)), __LINE__);
        }
        $this->treatmentType = $treatmentType;
        return $this;
    }
    /**
     * Get handlerCode value
     * @return string|null
     */
    public function getHandlerCode()
    {
        return $this->handlerCode;
    }
    /**
     * Set handlerCode value
     * @param string $handlerCode
     * @return \StructType\BehandlerArtKP
     */
    public function setHandlerCode($handlerCode = null)
    {
        // validation for constraint: string
        if (!is_null($handlerCode) && !is_string($handlerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handlerCode, true), gettype($handlerCode)), __LINE__);
        }
        $this->handlerCode = $handlerCode;
        return $this;
    }
    /**
     * Get handlerDescription value
     * @return string|null
     */
    public function getHandlerDescription()
    {
        return $this->handlerDescription;
    }
    /**
     * Set handlerDescription value
     * @param string $handlerDescription
     * @return \StructType\BehandlerArtKP
     */
    public function setHandlerDescription($handlerDescription = null)
    {
        // validation for constraint: string
        if (!is_null($handlerDescription) && !is_string($handlerDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handlerDescription, true), gettype($handlerDescription)), __LINE__);
        }
        $this->handlerDescription = $handlerDescription;
        return $this;
    }
    /**
     * Get handlerID value
     * @return string|null
     */
    public function getHandlerID()
    {
        return $this->handlerID;
    }
    /**
     * Set handlerID value
     * @param string $handlerID
     * @return \StructType\BehandlerArtKP
     */
    public function setHandlerID($handlerID = null)
    {
        // validation for constraint: string
        if (!is_null($handlerID) && !is_string($handlerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handlerID, true), gettype($handlerID)), __LINE__);
        }
        $this->handlerID = $handlerID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BehandlerArtKP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
