<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankAccount StructType
 * Meta information extracted from the WSDL
 * - documentation: Bankverbindung
 * @subpackage Structs
 */
class BankAccount extends AbstractStructBase
{
    /**
     * The bankCode
     * Meta information extracted from the WSDL
     * - documentation: Bankleitzahl
     * - base: xsd:string
     * - maxLength: 8
     * - minLength: 5
     * - minOccurs: 0
     * @var string
     */
    public $bankCode;
    /**
     * The bankName
     * Meta information extracted from the WSDL
     * - documentation: Bankname
     * - base: xsd:string
     * - maxLength: 100
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $bankName;
    /**
     * The bankAccountOwner
     * Meta information extracted from the WSDL
     * - documentation: Kontoinhaber alt (zwecks Abwärtskompatibilität weiterhin möglich)
     * - choice: bankAccountOwner | bankAccountOwnerFields
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bankAccountOwner;
    /**
     * The bankAccountOwnerFields
     * Meta information extracted from the WSDL
     * - documentation: Kontoinhaber
     * - choice: bankAccountOwner | bankAccountOwnerFields
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BankAccountOwner
     */
    public $bankAccountOwnerFields;
    /**
     * The bankAccountNumber
     * Meta information extracted from the WSDL
     * - documentation: Kontonummer
     * - base: xsd:string
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $bankAccountNumber;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - documentation: Land der Bankverbindung
     * @var \StructType\Country
     */
    public $country;
    /**
     * Constructor method for BankAccount
     * @uses BankAccount::setBankCode()
     * @uses BankAccount::setBankName()
     * @uses BankAccount::setBankAccountOwner()
     * @uses BankAccount::setBankAccountOwnerFields()
     * @uses BankAccount::setBankAccountNumber()
     * @uses BankAccount::setCountry()
     * @param string $bankCode
     * @param string $bankName
     * @param string $bankAccountOwner
     * @param \StructType\BankAccountOwner $bankAccountOwnerFields
     * @param string $bankAccountNumber
     * @param \StructType\Country $country
     */
    public function __construct($bankCode = null, $bankName = null, $bankAccountOwner = null, \StructType\BankAccountOwner $bankAccountOwnerFields = null, $bankAccountNumber = null, \StructType\Country $country = null)
    {
        $this
            ->setBankCode($bankCode)
            ->setBankName($bankName)
            ->setBankAccountOwner($bankAccountOwner)
            ->setBankAccountOwnerFields($bankAccountOwnerFields)
            ->setBankAccountNumber($bankAccountNumber)
            ->setCountry($country);
    }
    /**
     * Get bankCode value
     * @return string|null
     */
    public function getBankCode()
    {
        return $this->bankCode;
    }
    /**
     * Set bankCode value
     * @param string $bankCode
     * @return \StructType\BankAccount
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankCode) && !is_string($bankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankCode, true), gettype($bankCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($bankCode) && mb_strlen($bankCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($bankCode)), __LINE__);
        }
        // validation for constraint: minLength(5)
        if (!is_null($bankCode) && mb_strlen($bankCode) < 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 5', mb_strlen($bankCode)), __LINE__);
        }
        $this->bankCode = $bankCode;
        return $this;
    }
    /**
     * Get bankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->bankName;
    }
    /**
     * Set bankName value
     * @param string $bankName
     * @return \StructType\BankAccount
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($bankName) && mb_strlen($bankName) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($bankName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bankName) && mb_strlen($bankName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bankName)), __LINE__);
        }
        $this->bankName = $bankName;
        return $this;
    }
    /**
     * Get bankAccountOwner value
     * @return string|null
     */
    public function getBankAccountOwner()
    {
        return isset($this->bankAccountOwner) ? $this->bankAccountOwner : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBankAccountOwner method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBankAccountOwner method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBankAccountOwnerForChoiceConstraintsFromSetBankAccountOwner($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'bankAccountOwnerFields',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property bankAccountOwner can\'t be set as the property %s is already set. Only one property must be set among these properties: bankAccountOwner, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set bankAccountOwner value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $bankAccountOwner
     * @return \StructType\BankAccount
     */
    public function setBankAccountOwner($bankAccountOwner = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountOwner) && !is_string($bankAccountOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAccountOwner, true), gettype($bankAccountOwner)), __LINE__);
        }
        // validation for constraint: choice(bankAccountOwner, bankAccountOwnerFields)
        if ('' !== ($bankAccountOwnerChoiceErrorMessage = self::validateBankAccountOwnerForChoiceConstraintsFromSetBankAccountOwner($bankAccountOwner))) {
            throw new \InvalidArgumentException($bankAccountOwnerChoiceErrorMessage, __LINE__);
        }
        if (is_null($bankAccountOwner) || (is_array($bankAccountOwner) && empty($bankAccountOwner))) {
            unset($this->bankAccountOwner);
        } else {
            $this->bankAccountOwner = $bankAccountOwner;
        }
        return $this;
    }
    /**
     * Get bankAccountOwnerFields value
     * @return \StructType\BankAccountOwner|null
     */
    public function getBankAccountOwnerFields()
    {
        return isset($this->bankAccountOwnerFields) ? $this->bankAccountOwnerFields : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBankAccountOwnerFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBankAccountOwnerFields method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBankAccountOwnerFieldsForChoiceConstraintsFromSetBankAccountOwnerFields($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'bankAccountOwner',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property bankAccountOwnerFields can\'t be set as the property %s is already set. Only one property must be set among these properties: bankAccountOwnerFields, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set bankAccountOwnerFields value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BankAccountOwner $bankAccountOwnerFields
     * @return \StructType\BankAccount
     */
    public function setBankAccountOwnerFields(\StructType\BankAccountOwner $bankAccountOwnerFields = null)
    {
        // validation for constraint: choice(bankAccountOwner, bankAccountOwnerFields)
        if ('' !== ($bankAccountOwnerFieldsChoiceErrorMessage = self::validateBankAccountOwnerFieldsForChoiceConstraintsFromSetBankAccountOwnerFields($bankAccountOwnerFields))) {
            throw new \InvalidArgumentException($bankAccountOwnerFieldsChoiceErrorMessage, __LINE__);
        }
        if (is_null($bankAccountOwnerFields) || (is_array($bankAccountOwnerFields) && empty($bankAccountOwnerFields))) {
            unset($this->bankAccountOwnerFields);
        } else {
            $this->bankAccountOwnerFields = $bankAccountOwnerFields;
        }
        return $this;
    }
    /**
     * Get bankAccountNumber value
     * @return string|null
     */
    public function getBankAccountNumber()
    {
        return $this->bankAccountNumber;
    }
    /**
     * Set bankAccountNumber value
     * @param string $bankAccountNumber
     * @return \StructType\BankAccount
     */
    public function setBankAccountNumber($bankAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountNumber) && !is_string($bankAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAccountNumber, true), gettype($bankAccountNumber)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($bankAccountNumber) && mb_strlen($bankAccountNumber) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($bankAccountNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bankAccountNumber) && mb_strlen($bankAccountNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bankAccountNumber)), __LINE__);
        }
        $this->bankAccountNumber = $bankAccountNumber;
        return $this;
    }
    /**
     * Get country value
     * @return \StructType\Country|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param \StructType\Country $country
     * @return \StructType\BankAccount
     */
    public function setCountry(\StructType\Country $country = null)
    {
        $this->country = $country;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BankAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
