<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ambulant StructType
 * @subpackage Structs
 */
class Ambulant extends AbstractStructBase
{
    /**
     * The person
     * @var string
     */
    public $person;
    /**
     * The treatmentbill
     * Meta information extracted from the WSDL
     * - maxOccurs: 50
     * @var \StructType\TreatmentBill[]
     */
    public $treatmentbill;
    /**
     * Constructor method for ambulant
     * @uses Ambulant::setPerson()
     * @uses Ambulant::setTreatmentbill()
     * @param string $person
     * @param \StructType\TreatmentBill[] $treatmentbill
     */
    public function __construct($person = null, array $treatmentbill = array())
    {
        $this
            ->setPerson($person)
            ->setTreatmentbill($treatmentbill);
    }
    /**
     * Get person value
     * @return string|null
     */
    public function getPerson()
    {
        return $this->person;
    }
    /**
     * Set person value
     * @param string $person
     * @return \StructType\Ambulant
     */
    public function setPerson($person = null)
    {
        // validation for constraint: string
        if (!is_null($person) && !is_string($person)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($person, true), gettype($person)), __LINE__);
        }
        $this->person = $person;
        return $this;
    }
    /**
     * Get treatmentbill value
     * @return \StructType\TreatmentBill[]|null
     */
    public function getTreatmentbill()
    {
        return $this->treatmentbill;
    }
    /**
     * This method is responsible for validating the values passed to the setTreatmentbill method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTreatmentbill method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTreatmentbillForArrayConstraintsFromSetTreatmentbill(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ambulantTreatmentbillItem) {
            // validation for constraint: itemType
            if (!$ambulantTreatmentbillItem instanceof \StructType\TreatmentBill) {
                $invalidValues[] = is_object($ambulantTreatmentbillItem) ? get_class($ambulantTreatmentbillItem) : sprintf('%s(%s)', gettype($ambulantTreatmentbillItem), var_export($ambulantTreatmentbillItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The treatmentbill property can only contain items of type \StructType\TreatmentBill, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set treatmentbill value
     * @throws \InvalidArgumentException
     * @param \StructType\TreatmentBill[] $treatmentbill
     * @return \StructType\Ambulant
     */
    public function setTreatmentbill(array $treatmentbill = array())
    {
        // validation for constraint: array
        if ('' !== ($treatmentbillArrayErrorMessage = self::validateTreatmentbillForArrayConstraintsFromSetTreatmentbill($treatmentbill))) {
            throw new \InvalidArgumentException($treatmentbillArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($treatmentbill) && count($treatmentbill) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 50', count($treatmentbill)), __LINE__);
        }
        $this->treatmentbill = $treatmentbill;
        return $this;
    }
    /**
     * Add item to treatmentbill value
     * @throws \InvalidArgumentException
     * @param \StructType\TreatmentBill $item
     * @return \StructType\Ambulant
     */
    public function addToTreatmentbill(\StructType\TreatmentBill $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TreatmentBill) {
            throw new \InvalidArgumentException(sprintf('The treatmentbill property can only contain items of type \StructType\TreatmentBill, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($this->treatmentbill) && count($this->treatmentbill) >= 50) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 50', count($this->treatmentbill)), __LINE__);
        }
        $this->treatmentbill[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Ambulant
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
