<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for adressePrivatobjektType StructType
 * @subpackage Structs
 */
class AdressePrivatobjektType extends AbstractStructBase
{
    /**
     * The strasse
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 40
     * @var string
     */
    public $strasse;
    /**
     * The hausnummer
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 10
     * @var string
     */
    public $hausnummer;
    /**
     * The hausnummernZusatz
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $hausnummernZusatz;
    /**
     * The plz
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 5
     * @var string
     */
    public $plz;
    /**
     * The ort
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 40
     * @var string
     */
    public $ort;
    /**
     * Constructor method for adressePrivatobjektType
     * @uses AdressePrivatobjektType::setStrasse()
     * @uses AdressePrivatobjektType::setHausnummer()
     * @uses AdressePrivatobjektType::setHausnummernZusatz()
     * @uses AdressePrivatobjektType::setPlz()
     * @uses AdressePrivatobjektType::setOrt()
     * @param string $strasse
     * @param string $hausnummer
     * @param string $hausnummernZusatz
     * @param string $plz
     * @param string $ort
     */
    public function __construct($strasse = null, $hausnummer = null, $hausnummernZusatz = null, $plz = null, $ort = null)
    {
        $this
            ->setStrasse($strasse)
            ->setHausnummer($hausnummer)
            ->setHausnummernZusatz($hausnummernZusatz)
            ->setPlz($plz)
            ->setOrt($ort);
    }
    /**
     * Get strasse value
     * @return string|null
     */
    public function getStrasse()
    {
        return $this->strasse;
    }
    /**
     * Set strasse value
     * @param string $strasse
     * @return \StructType\AdressePrivatobjektType
     */
    public function setStrasse($strasse = null)
    {
        // validation for constraint: string
        if (!is_null($strasse) && !is_string($strasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strasse, true), gettype($strasse)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($strasse) && mb_strlen($strasse) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($strasse)), __LINE__);
        }
        $this->strasse = $strasse;
        return $this;
    }
    /**
     * Get hausnummer value
     * @return string|null
     */
    public function getHausnummer()
    {
        return $this->hausnummer;
    }
    /**
     * Set hausnummer value
     * @param string $hausnummer
     * @return \StructType\AdressePrivatobjektType
     */
    public function setHausnummer($hausnummer = null)
    {
        // validation for constraint: string
        if (!is_null($hausnummer) && !is_string($hausnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hausnummer, true), gettype($hausnummer)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($hausnummer) && mb_strlen($hausnummer) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($hausnummer)), __LINE__);
        }
        $this->hausnummer = $hausnummer;
        return $this;
    }
    /**
     * Get hausnummernZusatz value
     * @return string|null
     */
    public function getHausnummernZusatz()
    {
        return $this->hausnummernZusatz;
    }
    /**
     * Set hausnummernZusatz value
     * @param string $hausnummernZusatz
     * @return \StructType\AdressePrivatobjektType
     */
    public function setHausnummernZusatz($hausnummernZusatz = null)
    {
        // validation for constraint: string
        if (!is_null($hausnummernZusatz) && !is_string($hausnummernZusatz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hausnummernZusatz, true), gettype($hausnummernZusatz)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($hausnummernZusatz) && mb_strlen($hausnummernZusatz) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($hausnummernZusatz)), __LINE__);
        }
        $this->hausnummernZusatz = $hausnummernZusatz;
        return $this;
    }
    /**
     * Get plz value
     * @return string|null
     */
    public function getPlz()
    {
        return $this->plz;
    }
    /**
     * Set plz value
     * @param string $plz
     * @return \StructType\AdressePrivatobjektType
     */
    public function setPlz($plz = null)
    {
        // validation for constraint: string
        if (!is_null($plz) && !is_string($plz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plz, true), gettype($plz)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($plz) && mb_strlen($plz) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($plz)), __LINE__);
        }
        $this->plz = $plz;
        return $this;
    }
    /**
     * Get ort value
     * @return string|null
     */
    public function getOrt()
    {
        return $this->ort;
    }
    /**
     * Set ort value
     * @param string $ort
     * @return \StructType\AdressePrivatobjektType
     */
    public function setOrt($ort = null)
    {
        // validation for constraint: string
        if (!is_null($ort) && !is_string($ort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ort, true), gettype($ort)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($ort) && mb_strlen($ort) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($ort)), __LINE__);
        }
        $this->ort = $ort;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdressePrivatobjektType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
