<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Adress StructType
 * Meta information extracted from the WSDL
 * - documentation: Adressobjekt
 * @subpackage Structs
 */
class Adress extends AbstractStructBase
{
    /**
     * The externalCustomerAdressID
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $externalCustomerAdressID;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - documentation: Strasse
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $street;
    /**
     * The houseNumber
     * Meta information extracted from the WSDL
     * - documentation: Hausnummer
     * - base: xsd:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $houseNumber;
    /**
     * The additionalDetails
     * Meta information extracted from the WSDL
     * - documentation: Zusätzliche Daten wie z.B. Stiege
     * - base: xsd:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $additionalDetails;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - documentation: Land
     * @var \StructType\Country
     */
    public $state;
    /**
     * The streetPoBox
     * Meta information extracted from the WSDL
     * - documentation: Postleitzahl
     * - base: xsd:string
     * - maxLength: 10
     * @var string
     */
    public $streetPoBox;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - documentation: Stadt
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $city;
    /**
     * The mainAdress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $mainAdress;
    /**
     * Constructor method for Adress
     * @uses Adress::setExternalCustomerAdressID()
     * @uses Adress::setStreet()
     * @uses Adress::setHouseNumber()
     * @uses Adress::setAdditionalDetails()
     * @uses Adress::setState()
     * @uses Adress::setStreetPoBox()
     * @uses Adress::setCity()
     * @uses Adress::setMainAdress()
     * @param string $externalCustomerAdressID
     * @param string $street
     * @param string $houseNumber
     * @param string $additionalDetails
     * @param \StructType\Country $state
     * @param string $streetPoBox
     * @param string $city
     * @param bool $mainAdress
     */
    public function __construct($externalCustomerAdressID = null, $street = null, $houseNumber = null, $additionalDetails = null, \StructType\Country $state = null, $streetPoBox = null, $city = null, $mainAdress = null)
    {
        $this
            ->setExternalCustomerAdressID($externalCustomerAdressID)
            ->setStreet($street)
            ->setHouseNumber($houseNumber)
            ->setAdditionalDetails($additionalDetails)
            ->setState($state)
            ->setStreetPoBox($streetPoBox)
            ->setCity($city)
            ->setMainAdress($mainAdress);
    }
    /**
     * Get externalCustomerAdressID value
     * @return string|null
     */
    public function getExternalCustomerAdressID()
    {
        return $this->externalCustomerAdressID;
    }
    /**
     * Set externalCustomerAdressID value
     * @param string $externalCustomerAdressID
     * @return \StructType\Adress
     */
    public function setExternalCustomerAdressID($externalCustomerAdressID = null)
    {
        // validation for constraint: string
        if (!is_null($externalCustomerAdressID) && !is_string($externalCustomerAdressID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalCustomerAdressID, true), gettype($externalCustomerAdressID)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($externalCustomerAdressID) && mb_strlen($externalCustomerAdressID) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($externalCustomerAdressID)), __LINE__);
        }
        $this->externalCustomerAdressID = $externalCustomerAdressID;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\Adress
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($street) && mb_strlen($street) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param string $houseNumber
     * @return \StructType\Adress
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseNumber, true), gettype($houseNumber)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($houseNumber) && mb_strlen($houseNumber) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($houseNumber)), __LINE__);
        }
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get additionalDetails value
     * @return string|null
     */
    public function getAdditionalDetails()
    {
        return $this->additionalDetails;
    }
    /**
     * Set additionalDetails value
     * @param string $additionalDetails
     * @return \StructType\Adress
     */
    public function setAdditionalDetails($additionalDetails = null)
    {
        // validation for constraint: string
        if (!is_null($additionalDetails) && !is_string($additionalDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalDetails, true), gettype($additionalDetails)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($additionalDetails) && mb_strlen($additionalDetails) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($additionalDetails)), __LINE__);
        }
        $this->additionalDetails = $additionalDetails;
        return $this;
    }
    /**
     * Get state value
     * @return \StructType\Country|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param \StructType\Country $state
     * @return \StructType\Adress
     */
    public function setState(\StructType\Country $state = null)
    {
        $this->state = $state;
        return $this;
    }
    /**
     * Get streetPoBox value
     * @return string|null
     */
    public function getStreetPoBox()
    {
        return $this->streetPoBox;
    }
    /**
     * Set streetPoBox value
     * @param string $streetPoBox
     * @return \StructType\Adress
     */
    public function setStreetPoBox($streetPoBox = null)
    {
        // validation for constraint: string
        if (!is_null($streetPoBox) && !is_string($streetPoBox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetPoBox, true), gettype($streetPoBox)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($streetPoBox) && mb_strlen($streetPoBox) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($streetPoBox)), __LINE__);
        }
        $this->streetPoBox = $streetPoBox;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\Adress
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get mainAdress value
     * @return bool|null
     */
    public function getMainAdress()
    {
        return $this->mainAdress;
    }
    /**
     * Set mainAdress value
     * @param bool $mainAdress
     * @return \StructType\Adress
     */
    public function setMainAdress($mainAdress = null)
    {
        // validation for constraint: boolean
        if (!is_null($mainAdress) && !is_bool($mainAdress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mainAdress, true), gettype($mainAdress)), __LINE__);
        }
        $this->mainAdress = $mainAdress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Adress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
