<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for New ServiceType
 * @subpackage Services
 */
class _New extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named newBusinessCase
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCaseRequest $parameter
     * @return \StructType\NewBusinessCaseResponse|bool
     */
    public function newBusinessCase(\StructType\NewBusinessCaseRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCase($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named newBusinessCaseIVOnline
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCaseIVOnlineRequest $parameter
     * @return \StructType\NewBusinessCaseIVOnlineResponse|bool
     */
    public function newBusinessCaseIVOnline(\StructType\NewBusinessCaseIVOnlineRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCaseIVOnline($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named newBusinessCaseSMOnline
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCaseSMOnlineRequest $parameter
     * @return \StructType\NewBusinessCaseSMOnlineResponse|bool
     */
    public function newBusinessCaseSMOnline(\StructType\NewBusinessCaseSMOnlineRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCaseSMOnline($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named newBusinessCasePrefilled
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCasePrefilledRequest $parameter
     * @return \StructType\NewBusinessCasePrefilledResponse|bool
     */
    public function newBusinessCasePrefilled(\StructType\NewBusinessCasePrefilledRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCasePrefilled($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named newBusinessCaseCalculateAndSave
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCaseCalculateAndSaveRequest $parameter
     * @return \StructType\NewBusinessCaseCalculateAndSaveResponse|bool
     */
    public function newBusinessCaseCalculateAndSave(\StructType\NewBusinessCaseCalculateAndSaveRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCaseCalculateAndSave($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named newBusinessCaseToPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCaseToPolicyRequest $parameter
     * @return \StructType\NewBusinessCaseToPolicyResponse|bool
     */
    public function newBusinessCaseToPolicy(\StructType\NewBusinessCaseToPolicyRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCaseToPolicy($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named newBusinessCaseFromXml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCaseFromXmlRequest $parameter
     * @return \StructType\NewBusinessCaseFromXmlResponse|bool
     */
    public function newBusinessCaseFromXml(\StructType\NewBusinessCaseFromXmlRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCaseFromXml($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named newBusinessCaseSMOnlineTransfer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCaseSMOnlineTransferRequest $parameter
     * @return \StructType\NewBusinessCaseSMOnlineTransferResponse|bool
     */
    public function newBusinessCaseSMOnlineTransfer(\StructType\NewBusinessCaseSMOnlineTransferRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCaseSMOnlineTransfer($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named newBusinessCaseStorno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCaseStornoRequest $parameter
     * @return \StructType\NewBusinessCaseStornoResponse|bool
     */
    public function newBusinessCaseStorno(\StructType\NewBusinessCaseStornoRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCaseStorno($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named newBusinessCaseInkassoAenderung
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCaseInkassoAenderungRequest $parameter
     * @return \StructType\NewBusinessCaseInkassoAenderungResponse|bool
     */
    public function newBusinessCaseInkassoAenderung(\StructType\NewBusinessCaseInkassoAenderungRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCaseInkassoAenderung($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * newBusinessCaseVersicherungsBestaetigung
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NewBusinessCaseVersicherungsBestaetigungRequest $parameter
     * @return \StructType\NewBusinessCaseVersicherungsBestaetigungResponse|bool
     */
    public function newBusinessCaseVersicherungsBestaetigung(\StructType\NewBusinessCaseVersicherungsBestaetigungRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->newBusinessCaseVersicherungsBestaetigung($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\NewBusinessCaseCalculateAndSaveResponse|\StructType\NewBusinessCaseFromXmlResponse|\StructType\NewBusinessCaseInkassoAenderungResponse|\StructType\NewBusinessCaseIVOnlineResponse|\StructType\NewBusinessCasePrefilledResponse|\StructType\NewBusinessCaseResponse|\StructType\NewBusinessCaseSMOnlineResponse|\StructType\NewBusinessCaseSMOnlineTransferResponse|\StructType\NewBusinessCaseStornoResponse|\StructType\NewBusinessCaseToPolicyResponse|\StructType\NewBusinessCaseVersicherungsBestaetigungResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
