<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reset ServiceType
 * @subpackage Services
 */
class Reset extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named resetSignDocuments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ResetSignDocumentsRequest $parameter
     * @return \StructType\ResetSignDocumentsResponse|bool
     */
    public function resetSignDocuments(\StructType\ResetSignDocumentsRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->resetSignDocuments($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named resetUserPassword
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ResetUserPasswordRequest $parameter
     * @return \StructType\ResetUserPasswordResponse|bool
     */
    public function resetUserPassword(\StructType\ResetUserPasswordRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->resetUserPassword($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named resetUserPasswordQuestionAnswer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ResetUserPasswordQuestionAnswerRequest $parameter
     * @return \StructType\ResetUserPasswordQuestionAnswerResponse|bool
     */
    public function resetUserPasswordQuestionAnswer(\StructType\ResetUserPasswordQuestionAnswerRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->resetUserPasswordQuestionAnswer($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named resetUserNewsletter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ResetUserNewsletterRequest $parameter
     * @return \StructType\ResetUserNewsletterResponse|bool
     */
    public function resetUserNewsletter(\StructType\ResetUserNewsletterRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->resetUserNewsletter($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResetSignDocumentsResponse|\StructType\ResetUserNewsletterResponse|\StructType\ResetUserPasswordQuestionAnswerResponse|\StructType\ResetUserPasswordResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
