<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Has ServiceType
 * @subpackage Services
 */
class Has extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named hasZeusdaten
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HasZeusDatenRequest $parameter
     * @return \StructType\HasZeusDatenResponse|bool
     */
    public function hasZeusdaten(\StructType\HasZeusDatenRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->hasZeusdaten($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\HasZeusDatenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
