<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Browse ServiceType
 * @subpackage Services
 */
class Browse extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named browseMessageFromMQ
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BrowseMessageFromMQRequest $parameter
     * @return \StructType\BrowseMessageFromMQResponse|bool
     */
    public function browseMessageFromMQ(\StructType\BrowseMessageFromMQRequest $parameter)
    {
        try {
            $this->setResult($this->getSoapClient()->browseMessageFromMQ($parameter));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BrowseMessageFromMQResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
