<?php

namespace EnumType;

/**
 * This class stands for zustandsbeschreibungType EnumType
 * @subpackage Enumerations
 */
class ZustandsbeschreibungType
{
    /**
     * Constant for value 'Besichtigung durch Betreuer'
     * @return string 'Besichtigung durch Betreuer'
     */
    const VALUE_BESICHTIGUNG_DURCH_BETREUER = 'Besichtigung durch Betreuer';
    /**
     * Constant for value 'Kaufvertrag eines Markenhändlers mit Beschreibung (Kopie
     * erforderlich)'
     * @return string 'Kaufvertrag eines Markenhändlers mit Beschreibung (Kopie erforderlich)'
     */
    const VALUE_KAUFVERTRAG_EINES_MARKENH_ÄNDLERS_MIT_BESCHREIBUNG_KOPIE_ERFORDERLICH = 'Kaufvertrag eines Markenhändlers mit Beschreibung (Kopie erforderlich)';
    /**
     * Constant for value 'Besichtigung durch ÖAMTC'
     * @return string 'Besichtigung durch ÖAMTC'
     */
    const VALUE_BESICHTIGUNG_DURCH_ÖAMTC = 'Besichtigung durch ÖAMTC';
    /**
     * Constant for value 'Nachbesichtigung'
     * @return string 'Nachbesichtigung'
     */
    const VALUE_NACHBESICHTIGUNG = 'Nachbesichtigung';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BESICHTIGUNG_DURCH_BETREUER
     * @uses self::VALUE_KAUFVERTRAG_EINES_MARKENH_ÄNDLERS_MIT_BESCHREIBUNG_KOPIE_ERFORDERLICH
     * @uses self::VALUE_BESICHTIGUNG_DURCH_ÖAMTC
     * @uses self::VALUE_NACHBESICHTIGUNG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BESICHTIGUNG_DURCH_BETREUER,
            self::VALUE_KAUFVERTRAG_EINES_MARKENH_ÄNDLERS_MIT_BESCHREIBUNG_KOPIE_ERFORDERLICH,
            self::VALUE_BESICHTIGUNG_DURCH_ÖAMTC,
            self::VALUE_NACHBESICHTIGUNG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
