<?php

namespace EnumType;

/**
 * This class stands for ZahlungsweiseType EnumType
 * @subpackage Enumerations
 */
class ZahlungsweiseType_1
{
    /**
     * Constant for value 'monatlich'
     * @return string 'monatlich'
     */
    const VALUE_MONATLICH_1 = 'monatlich';
    /**
     * Constant for value 'vierteljaehrlich'
     * @return string 'vierteljaehrlich'
     */
    const VALUE_VIERTELJAEHRLICH = 'vierteljaehrlich';
    /**
     * Constant for value 'halbjaehrlich'
     * @return string 'halbjaehrlich'
     */
    const VALUE_HALBJAEHRLICH = 'halbjaehrlich';
    /**
     * Constant for value 'jaehrlich'
     * @return string 'jaehrlich'
     */
    const VALUE_JAEHRLICH = 'jaehrlich';
    /**
     * Constant for value 'einmalig'
     * @return string 'einmalig'
     */
    const VALUE_EINMALIG = 'einmalig';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MONATLICH_1
     * @uses self::VALUE_VIERTELJAEHRLICH
     * @uses self::VALUE_HALBJAEHRLICH
     * @uses self::VALUE_JAEHRLICH
     * @uses self::VALUE_EINMALIG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MONATLICH_1,
            self::VALUE_VIERTELJAEHRLICH,
            self::VALUE_HALBJAEHRLICH,
            self::VALUE_JAEHRLICH,
            self::VALUE_EINMALIG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
