<?php

namespace EnumType;

/**
 * This class stands for zahlungsweiseType EnumType
 * @subpackage Enumerations
 */
class ZahlungsweiseType
{
    /**
     * Constant for value 'jährlich'
     * @return string 'jährlich'
     */
    const VALUE_J_ÄHRLICH = 'jährlich';
    /**
     * Constant for value 'halbjährlich'
     * @return string 'halbjährlich'
     */
    const VALUE_HALBJ_ÄHRLICH = 'halbjährlich';
    /**
     * Constant for value 'vierteljährlich'
     * @return string 'vierteljährlich'
     */
    const VALUE_VIERTELJ_ÄHRLICH = 'vierteljährlich';
    /**
     * Constant for value 'monatlich'
     * @return string 'monatlich'
     */
    const VALUE_MONATLICH = 'monatlich';
    /**
     * Constant for value 'einmalig'
     * @return string 'einmalig'
     */
    const VALUE_EINMALIG = 'einmalig';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_J_ÄHRLICH
     * @uses self::VALUE_HALBJ_ÄHRLICH
     * @uses self::VALUE_VIERTELJ_ÄHRLICH
     * @uses self::VALUE_MONATLICH
     * @uses self::VALUE_EINMALIG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_J_ÄHRLICH,
            self::VALUE_HALBJ_ÄHRLICH,
            self::VALUE_VIERTELJ_ÄHRLICH,
            self::VALUE_MONATLICH,
            self::VALUE_EINMALIG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
