<?php

namespace EnumType;

/**
 * This class stands for versicherteFahrzeugeAuswahl EnumType
 * @subpackage Enumerations
 */
class VersicherteFahrzeugeAuswahl
{
    /**
     * Constant for value 'alle: Einspurige, PKW, LKW bis 1.5t, Zugmaschinen (private
     * Verwendung)'
     * @return string 'alle: Einspurige, PKW, LKW bis 1.5t, Zugmaschinen (private Verwendung)'
     */
    const VALUE_ALLE_EINSPURIGE_PKW_LKW_BIS_1_5_T_ZUGMASCHINEN_PRIVATE_VERWENDUNG = 'alle: Einspurige, PKW, LKW bis 1.5t, Zugmaschinen (private Verwendung)';
    /**
     * Constant for value 'individuell'
     * @return string 'individuell'
     */
    const VALUE_INDIVIDUELL = 'individuell';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALLE_EINSPURIGE_PKW_LKW_BIS_1_5_T_ZUGMASCHINEN_PRIVATE_VERWENDUNG
     * @uses self::VALUE_INDIVIDUELL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALLE_EINSPURIGE_PKW_LKW_BIS_1_5_T_ZUGMASCHINEN_PRIVATE_VERWENDUNG,
            self::VALUE_INDIVIDUELL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
