<?php

namespace EnumType;

/**
 * This class stands for varianteType EnumType
 * @subpackage Enumerations
 */
class VarianteType
{
    /**
     * Constant for value 'Premiumschutz'
     * @return string 'Premiumschutz'
     */
    const VALUE_PREMIUMSCHUTZ = 'Premiumschutz';
    /**
     * Constant for value 'Classicschutz'
     * @return string 'Classicschutz'
     */
    const VALUE_CLASSICSCHUTZ = 'Classicschutz';
    /**
     * Constant for value 'Basisschutz'
     * @return string 'Basisschutz'
     */
    const VALUE_BASISSCHUTZ = 'Basisschutz';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PREMIUMSCHUTZ
     * @uses self::VALUE_CLASSICSCHUTZ
     * @uses self::VALUE_BASISSCHUTZ
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PREMIUMSCHUTZ,
            self::VALUE_CLASSICSCHUTZ,
            self::VALUE_BASISSCHUTZ,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
