<?php

namespace EnumType;

/**
 * This class stands for typeOfAccident EnumType
 * @subpackage Enumerations
 */
class TypeOfAccident
{
    /**
     * Constant for value 'Arbeitsunfall'
     * @return string 'Arbeitsunfall'
     */
    const VALUE_ARBEITSUNFALL = 'Arbeitsunfall';
    /**
     * Constant for value 'in der Freizeit/Sonstige'
     * @return string 'in der Freizeit/Sonstige'
     */
    const VALUE_IN_DER_FREIZEIT_SONSTIGE = 'in der Freizeit/Sonstige';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ARBEITSUNFALL
     * @uses self::VALUE_IN_DER_FREIZEIT_SONSTIGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ARBEITSUNFALL,
            self::VALUE_IN_DER_FREIZEIT_SONSTIGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
