<?php

namespace EnumType;

/**
 * This class stands for typVorlage EnumType
 * Meta information extracted from the WSDL
 * - documentation: Typ des Attachments: 4..Antrag 5..Sepa-Mandat 6..elektronische Kommunikation 7..Basisblatt 8..Gesundheitsfragen 9..Sonstiges
 * @subpackage Enumerations
 */
class TypVorlage
{
    /**
     * Constant for value '4'
     * Meta information extracted from the WSDL
     * - id: AttachmentTypVorlageAntrag
     * @return string '4'
     */
    const VALUE_4 = '4';
    /**
     * Constant for value '5'
     * Meta information extracted from the WSDL
     * - id: AttachmentTypVorlageSepa
     * @return string '5'
     */
    const VALUE_5 = '5';
    /**
     * Constant for value '7'
     * Meta information extracted from the WSDL
     * - id: AttachmentTypVorlageBasisBlatt
     * @return string '7'
     */
    const VALUE_7 = '7';
    /**
     * Constant for value '6'
     * Meta information extracted from the WSDL
     * - id: AttachmentTypVorlageElektrKomm
     * @return string '6'
     */
    const VALUE_6 = '6';
    /**
     * Constant for value '8'
     * Meta information extracted from the WSDL
     * - id: AttachmentTypVorlageGesundheitsfragen
     * @return string '8'
     */
    const VALUE_8 = '8';
    /**
     * Constant for value '9'
     * Meta information extracted from the WSDL
     * - id: AttachmentTypVorlageSonstiges
     * @return string '9'
     */
    const VALUE_9 = '9';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_4
     * @uses self::VALUE_5
     * @uses self::VALUE_7
     * @uses self::VALUE_6
     * @uses self::VALUE_8
     * @uses self::VALUE_9
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_4,
            self::VALUE_5,
            self::VALUE_7,
            self::VALUE_6,
            self::VALUE_8,
            self::VALUE_9,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
