<?php

namespace EnumType;

/**
 * This class stands for TypRechtsform EnumType
 * @subpackage Enumerations
 */
class TypRechtsform
{
    /**
     * Constant for value '1'
     * Meta information extracted from the WSDL
     * - id: KG
     * @return string '1'
     */
    const VALUE_1 = '1';
    /**
     * Constant for value '2'
     * Meta information extracted from the WSDL
     * - id: GmbH
     * @return string '2'
     */
    const VALUE_2 = '2';
    /**
     * Constant for value '3'
     * Meta information extracted from the WSDL
     * - id: AG
     * @return string '3'
     */
    const VALUE_3 = '3';
    /**
     * Constant for value '4'
     * Meta information extracted from the WSDL
     * - id: Verein
     * @return string '4'
     */
    const VALUE_4 = '4';
    /**
     * Constant for value '5'
     * Meta information extracted from the WSDL
     * - id: OG
     * @return string '5'
     */
    const VALUE_5 = '5';
    /**
     * Constant for value '10'
     * Meta information extracted from the WSDL
     * - id: Genossenschaft
     * @return string '10'
     */
    const VALUE_10 = '10';
    /**
     * Constant for value '12'
     * Meta information extracted from the WSDL
     * - id: GmbHCoKG
     * @return string '12'
     */
    const VALUE_12 = '12';
    /**
     * Constant for value '13'
     * Meta information extracted from the WSDL
     * - id: GesbR
     * @return string '13'
     */
    const VALUE_13 = '13';
    /**
     * Constant for value '16'
     * Meta information extracted from the WSDL
     * - id: Privatstiftung
     * @return string '16'
     */
    const VALUE_16 = '16';
    /**
     * Constant for value '17'
     * Meta information extracted from the WSDL
     * - id: VVaG
     * @return string '17'
     */
    const VALUE_17 = '17';
    /**
     * Constant for value '20'
     * Meta information extracted from the WSDL
     * - id: StG
     * @return string '20'
     */
    const VALUE_20 = '20';
    /**
     * Constant for value '21'
     * Meta information extracted from the WSDL
     * - id: Einzelunternehmen
     * @return string '21'
     */
    const VALUE_21 = '21';
    /**
     * Constant for value '22'
     * Meta information extracted from the WSDL
     * - id: Sparkasse
     * @return string '22'
     */
    const VALUE_22 = '22';
    /**
     * Constant for value '23'
     * Meta information extracted from the WSDL
     * - id: AusländEURechtsform
     * @return string '23'
     */
    const VALUE_23 = '23';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_1
     * @uses self::VALUE_2
     * @uses self::VALUE_3
     * @uses self::VALUE_4
     * @uses self::VALUE_5
     * @uses self::VALUE_10
     * @uses self::VALUE_12
     * @uses self::VALUE_13
     * @uses self::VALUE_16
     * @uses self::VALUE_17
     * @uses self::VALUE_20
     * @uses self::VALUE_21
     * @uses self::VALUE_22
     * @uses self::VALUE_23
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_1,
            self::VALUE_2,
            self::VALUE_3,
            self::VALUE_4,
            self::VALUE_5,
            self::VALUE_10,
            self::VALUE_12,
            self::VALUE_13,
            self::VALUE_16,
            self::VALUE_17,
            self::VALUE_20,
            self::VALUE_21,
            self::VALUE_22,
            self::VALUE_23,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
