<?php

namespace EnumType;

/**
 * This class stands for taxiVerwendungsartType EnumType
 * @subpackage Enumerations
 */
class TaxiVerwendungsartType
{
    /**
     * Constant for value 'Landeshauptstadt'
     * @return string 'Landeshauptstadt'
     */
    const VALUE_LANDESHAUPTSTADT = 'Landeshauptstadt';
    /**
     * Constant for value 'Familienbetrieb'
     * @return string 'Familienbetrieb'
     */
    const VALUE_FAMILIENBETRIEB = 'Familienbetrieb';
    /**
     * Constant for value 'nicht Landeshauptstadt'
     * @return string 'nicht Landeshauptstadt'
     */
    const VALUE_NICHT_LANDESHAUPTSTADT = 'nicht Landeshauptstadt';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LANDESHAUPTSTADT
     * @uses self::VALUE_FAMILIENBETRIEB
     * @uses self::VALUE_NICHT_LANDESHAUPTSTADT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LANDESHAUPTSTADT,
            self::VALUE_FAMILIENBETRIEB,
            self::VALUE_NICHT_LANDESHAUPTSTADT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
