<?php

namespace EnumType;

/**
 * This class stands for Section EnumType
 * Meta information extracted from the WSDL
 * - documentation: Sektion z.B. : 1 oder 4 oder 6
 * @subpackage Enumerations
 */
class Section
{
    /**
     * Constant for value '1'
     * Meta information extracted from the WSDL
     * - id: ONE
     * @return string '1'
     */
    const VALUE_1 = '1';
    /**
     * Constant for value '4'
     * Meta information extracted from the WSDL
     * - id: FOUR
     * @return string '4'
     */
    const VALUE_4 = '4';
    /**
     * Constant for value '6'
     * Meta information extracted from the WSDL
     * - id: SIX
     * @return string '6'
     */
    const VALUE_6 = '6';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_1
     * @uses self::VALUE_4
     * @uses self::VALUE_6
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_1,
            self::VALUE_4,
            self::VALUE_6,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
