<?php

namespace EnumType;

/**
 * This class stands for schaedenAnScheibenKleinglasType EnumType
 * @subpackage Enumerations
 */
class SchaedenAnScheibenKleinglasType
{
    /**
     * Constant for value 'keine Schäden an Scheiben / Kleinglas'
     * @return string 'keine Schäden an Scheiben / Kleinglas'
     */
    const VALUE_KEINE_SCH_ÄDEN_AN_SCHEIBEN_KLEINGLAS = 'keine Schäden an Scheiben / Kleinglas';
    /**
     * Constant for value 'Schäden an Scheiben / Kleinglas'
     * @return string 'Schäden an Scheiben / Kleinglas'
     */
    const VALUE_SCH_ÄDEN_AN_SCHEIBEN_KLEINGLAS = 'Schäden an Scheiben / Kleinglas';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KEINE_SCH_ÄDEN_AN_SCHEIBEN_KLEINGLAS
     * @uses self::VALUE_SCH_ÄDEN_AN_SCHEIBEN_KLEINGLAS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KEINE_SCH_ÄDEN_AN_SCHEIBEN_KLEINGLAS,
            self::VALUE_SCH_ÄDEN_AN_SCHEIBEN_KLEINGLAS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
