<?php

namespace EnumType;

/**
 * This class stands for schaedenAmFahrzeugType EnumType
 * @subpackage Enumerations
 */
class SchaedenAmFahrzeugType
{
    /**
     * Constant for value 'keine Schäden an der Karosserie'
     * @return string 'keine Schäden an der Karosserie'
     */
    const VALUE_KEINE_SCH_ÄDEN_AN_DER_KAROSSERIE = 'keine Schäden an der Karosserie';
    /**
     * Constant for value 'Schäden an der Karosserie'
     * @return string 'Schäden an der Karosserie'
     */
    const VALUE_SCH_ÄDEN_AN_DER_KAROSSERIE = 'Schäden an der Karosserie';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KEINE_SCH_ÄDEN_AN_DER_KAROSSERIE
     * @uses self::VALUE_SCH_ÄDEN_AN_DER_KAROSSERIE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KEINE_SCH_ÄDEN_AN_DER_KAROSSERIE,
            self::VALUE_SCH_ÄDEN_AN_DER_KAROSSERIE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
