<?php

namespace EnumType;

/**
 * This class stands for rsKundengruppeType EnumType
 * @subpackage Enumerations
 */
class RsKundengruppeType
{
    /**
     * Constant for value 'Familie/Paar'
     * @return string 'Familie/Paar'
     */
    const VALUE_FAMILIE_PAAR = 'Familie/Paar';
    /**
     * Constant for value 'Alleinerzieher/Single'
     * @return string 'Alleinerzieher/Single'
     */
    const VALUE_ALLEINERZIEHER_SINGLE = 'Alleinerzieher/Single';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FAMILIE_PAAR
     * @uses self::VALUE_ALLEINERZIEHER_SINGLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FAMILIE_PAAR,
            self::VALUE_ALLEINERZIEHER_SINGLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
