<?php

namespace EnumType;

/**
 * This class stands for regionaldirektionType EnumType
 * @subpackage Enumerations
 */
class RegionaldirektionType
{
    /**
     * Constant for value 'Wien'
     * @return string 'Wien'
     */
    const VALUE_WIEN = 'Wien';
    /**
     * Constant for value 'Niederösterreich'
     * @return string 'Niederösterreich'
     */
    const VALUE_NIEDER_ÖSTERREICH = 'Niederösterreich';
    /**
     * Constant for value 'Oberösterreich'
     * @return string 'Oberösterreich'
     */
    const VALUE_OBER_ÖSTERREICH = 'Oberösterreich';
    /**
     * Constant for value 'Salzburg'
     * @return string 'Salzburg'
     */
    const VALUE_SALZBURG = 'Salzburg';
    /**
     * Constant for value 'Tirol'
     * @return string 'Tirol'
     */
    const VALUE_TIROL = 'Tirol';
    /**
     * Constant for value 'Vorarlberg'
     * @return string 'Vorarlberg'
     */
    const VALUE_VORARLBERG = 'Vorarlberg';
    /**
     * Constant for value 'Burgenland'
     * @return string 'Burgenland'
     */
    const VALUE_BURGENLAND = 'Burgenland';
    /**
     * Constant for value 'Steiermark'
     * @return string 'Steiermark'
     */
    const VALUE_STEIERMARK = 'Steiermark';
    /**
     * Constant for value 'Kärnten/Osttirol'
     * @return string 'Kärnten/Osttirol'
     */
    const VALUE_K_ÄRNTEN_OSTTIROL = 'Kärnten/Osttirol';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WIEN
     * @uses self::VALUE_NIEDER_ÖSTERREICH
     * @uses self::VALUE_OBER_ÖSTERREICH
     * @uses self::VALUE_SALZBURG
     * @uses self::VALUE_TIROL
     * @uses self::VALUE_VORARLBERG
     * @uses self::VALUE_BURGENLAND
     * @uses self::VALUE_STEIERMARK
     * @uses self::VALUE_K_ÄRNTEN_OSTTIROL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WIEN,
            self::VALUE_NIEDER_ÖSTERREICH,
            self::VALUE_OBER_ÖSTERREICH,
            self::VALUE_SALZBURG,
            self::VALUE_TIROL,
            self::VALUE_VORARLBERG,
            self::VALUE_BURGENLAND,
            self::VALUE_STEIERMARK,
            self::VALUE_K_ÄRNTEN_OSTTIROL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
