<?php

namespace EnumType;

/**
 * This class stands for rabattgrundType EnumType
 * @subpackage Enumerations
 */
class RabattgrundType
{
    /**
     * Constant for value 'außertariflicher Sonderrabatt'
     * @return string 'außertariflicher Sonderrabatt'
     */
    const VALUE_AU_ßERTARIFLICHER_SONDERRABATT = 'außertariflicher Sonderrabatt';
    /**
     * Constant for value 'Provisionsverzicht'
     * @return string 'Provisionsverzicht'
     */
    const VALUE_PROVISIONSVERZICHT = 'Provisionsverzicht';
    /**
     * Constant for value 'Fuhrparknachlass'
     * @return string 'Fuhrparknachlass'
     */
    const VALUE_FUHRPARKNACHLASS = 'Fuhrparknachlass';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AU_ßERTARIFLICHER_SONDERRABATT
     * @uses self::VALUE_PROVISIONSVERZICHT
     * @uses self::VALUE_FUHRPARKNACHLASS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AU_ßERTARIFLICHER_SONDERRABATT,
            self::VALUE_PROVISIONSVERZICHT,
            self::VALUE_FUHRPARKNACHLASS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
