<?php

namespace EnumType;

/**
 * This class stands for produktvarianteType EnumType
 * @subpackage Enumerations
 */
class ProduktvarianteType
{
    /**
     * Constant for value 'Kfz-Schutz'
     * @return string 'Kfz-Schutz'
     */
    const VALUE_KFZ_SCHUTZ = 'Kfz-Schutz';
    /**
     * Constant for value 'eKfz-Sicherheitspaket'
     * Meta information extracted from the WSDL
     * - documentation: Nur bei e-KFZ verfügbar
     * @return string 'eKfz-Sicherheitspaket'
     */
    const VALUE_E_KFZ_SICHERHEITSPAKET = 'eKfz-Sicherheitspaket';
    /**
     * Constant for value 'KMU-Schutz'
     * @return string 'KMU-Schutz'
     */
    const VALUE_KMU_SCHUTZ = 'KMU-Schutz';
    /**
     * Constant for value 'Sicherheitspaket'
     * @return string 'Sicherheitspaket'
     */
    const VALUE_SICHERHEITSPAKET = 'Sicherheitspaket';
    /**
     * Constant for value 'Standardschutz'
     * @return string 'Standardschutz'
     */
    const VALUE_STANDARDSCHUTZ = 'Standardschutz';
    /**
     * Constant for value 'VVD-Autohausbündel'
     * @return string 'VVD-Autohausbündel'
     */
    const VALUE_VVD_AUTOHAUSB_ÜNDEL = 'VVD-Autohausbündel';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KFZ_SCHUTZ
     * @uses self::VALUE_E_KFZ_SICHERHEITSPAKET
     * @uses self::VALUE_KMU_SCHUTZ
     * @uses self::VALUE_SICHERHEITSPAKET
     * @uses self::VALUE_STANDARDSCHUTZ
     * @uses self::VALUE_VVD_AUTOHAUSB_ÜNDEL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KFZ_SCHUTZ,
            self::VALUE_E_KFZ_SICHERHEITSPAKET,
            self::VALUE_KMU_SCHUTZ,
            self::VALUE_SICHERHEITSPAKET,
            self::VALUE_STANDARDSCHUTZ,
            self::VALUE_VVD_AUTOHAUSB_ÜNDEL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
