<?php

namespace EnumType;

/**
 * This class stands for pauschalsummeType EnumType
 * @subpackage Enumerations
 */
class PauschalsummeType
{
    /**
     * Constant for value '7,6 Mio'
     * @return string '7,6 Mio'
     */
    const VALUE_7_6_MIO = '7,6 Mio';
    /**
     * Constant for value '10 Mio'
     * @return string '10 Mio'
     */
    const VALUE_10_MIO = '10 Mio';
    /**
     * Constant for value '15 Mio'
     * @return string '15 Mio'
     */
    const VALUE_15_MIO = '15 Mio';
    /**
     * Constant for value '20 Mio'
     * @return string '20 Mio'
     */
    const VALUE_20_MIO = '20 Mio';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_7_6_MIO
     * @uses self::VALUE_10_MIO
     * @uses self::VALUE_15_MIO
     * @uses self::VALUE_20_MIO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_7_6_MIO,
            self::VALUE_10_MIO,
            self::VALUE_15_MIO,
            self::VALUE_20_MIO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
